/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.js;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.discovery.dir.BaseCustomCollector;
import com.ibm.appscan.discovery.dir.FileCollectorStrategy;
import com.ibm.appscan.discovery.js.IJavaScriptConstants;
import com.ibm.appscan.exclude.ExclusionProvider;
import com.ibm.appscan.exclude.exclusions.BaseExclusion;
import com.ibm.appscan.exclude.exclusions.ExclusionException;
import com.ibm.appscan.internal.discovery.js.ClientJavaScriptStrategy;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClientJavaScriptCollector
extends BaseCustomCollector
implements IJavaScriptConstants {
    private List<String> jsExtensions = Arrays.asList("js", "hbs", "jsf", "jsx", "mjs", "rjs", "wlapp", "ts", "tsx", "svg", "vue");
    private static final String SCRIPT_TAG = "<script";

    public ClientJavaScriptCollector(File crawlRoot, Set<StringPattern> includes, Set<StringPattern> excludes) {
        super(crawlRoot, includes, excludes);
    }

    public ClientJavaScriptCollector(File crawlRoot) {
        super(crawlRoot, new HashSet(), new HashSet());
    }

    public String getType() {
        return "ClientJavaScriptCollector";
    }

    protected boolean acceptFile(File file) {
        try {
            BaseExclusion js_excluder = ExclusionProvider.getExclusion((String)"JavaScript");
            if (js_excluder.isFileExcluded(file)) {
                return false;
            }
        }
        catch (ExclusionException e) {
            CommonCore.getLogManager().log((Exception)((Object)e));
        }
        return file.getName().equalsIgnoreCase("config.xml") || super.acceptFile(file) && this.containsJS(file);
    }

    private boolean containsJS(File file) {
        String extension = FileUtil.getFileExtension((File)file);
        if (!this.jsExtensions.contains(extension)) {
            try {
                return IOUtil.readFileIntoString((File)file).contains(SCRIPT_TAG);
            }
            catch (IOException e) {
                CommonCore.getLogManager().log((Exception)e);
            }
        }
        return true;
    }

    protected String getFileExtensionSetName() {
        return "javascript";
    }

    protected ScanTargetStrategy getScanTargetStrategy(ScanTargetStrategy parentStrategy) {
        String root = this.getCrawlRoot().getAbsolutePath();
        if (parentStrategy != null && parentStrategy instanceof FileCollectorStrategy) {
            root = ((FileCollectorStrategy)parentStrategy).getStagingDirectory().getAbsolutePath();
        }
        return new ClientJavaScriptStrategy(root, this.getScanFiles());
    }
}

