/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.grammar.string;

import com.ibm.wala.automaton.DMap;
import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.SimpleGrammarCopier;
import com.ibm.wala.automaton.grammar.string.SingletonGrammar;
import com.ibm.wala.automaton.string.Automaton;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.FreshStateFactory;
import com.ibm.wala.automaton.string.FreshVariableFactory;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.IStateFactory;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolFactory;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.IValueSymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.automaton.string.SimpleVariableFactory;
import com.ibm.wala.automaton.string.Transition;
import com.ibm.wala.util.MonitorUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RTNRegularApproximation {
    public static IContextFreeGrammar toRegularGrammar(IContextFreeGrammar cfg, IVariableFactory<IVariable> varFactory, MonitorUtil.IProgressMonitor monitor) {
        IAutomaton fst = Grammars.toAutomaton(cfg, varFactory, monitor);
        return Grammars.toCFG(fst, varFactory);
    }

    public static IAutomaton toSingletonAutomaton(SingletonGrammar sg, IVariableFactory<IVariable> varFactory) {
        IValueSymbol[] v = sg.getTheValue();
        List<IValueSymbol> symList = Arrays.asList(v);
        return Automatons.createAutomaton(symList);
    }

    public static IAutomaton toAutomaton(IContextFreeGrammar cfg, IVariableFactory<IVariable> varFactory, MonitorUtil.IProgressMonitor monitor) {
        if (cfg instanceof SingletonGrammar) {
            return RTNRegularApproximation.toSingletonAutomaton((SingletonGrammar)cfg, varFactory);
        }
        IContextFreeGrammar ncfg = (IContextFreeGrammar)cfg.copy(SimpleGrammarCopier.defaultCopier);
        Grammars.simplifyRules(ncfg, varFactory);
        final FreshStateFactory sf = new FreshStateFactory();
        DMap<IVariable, IState> iniMap = new DMap<IVariable, IState>(new DMap.Factory<IVariable, IState>(){

            @Override
            public IState create(IVariable key) {
                return sf.createState("s");
            }
        });
        DMap<IVariable, IState> finMap = new DMap<IVariable, IState>(new DMap.Factory<IVariable, IState>(){

            @Override
            public IState create(IVariable key) {
                return sf.createState("s");
            }
        });
        IAutomaton fst = RTNRegularApproximation.toAutomaton(ncfg, iniMap, finMap, sf, monitor);
        Automatons.eliminateEpsilonTransitions(fst);
        Automatons.eliminateUnreachableStates(fst);
        return fst;
    }

    private static IAutomaton toAutomaton(IContextFreeGrammar ncfg, Map<IVariable, IState> iniMap, Map<IVariable, IState> finMap, IStateFactory sf, MonitorUtil.IProgressMonitor monitor) {
        HashSet<ITransition> transitions = new HashSet<ITransition>();
        for (IProductionRule r : ncfg.getRules()) {
            RTNRegularApproximation.constructTransitions(r, transitions, iniMap, finMap, sf);
        }
        IState finalState = finMap.get(ncfg.getStartSymbol());
        Automaton result = new Automaton(iniMap.get(ncfg.getStartSymbol()), Collections.singleton(finalState), transitions);
        return Automatons.minimize(result, monitor);
    }

    private static void constructTransitions(IProductionRule r, Set<ITransition> transitions, Map<IVariable, IState> iniMap, Map<IVariable, IState> finMap, IStateFactory sf) {
        int rsize = r.getRight().size();
        switch (rsize) {
            case 0: {
                IVariable lv = r.getLeft();
                Transition t1 = new Transition(iniMap.get(lv), finMap.get(lv));
                transitions.add(t1);
                break;
            }
            case 1: {
                IVariable lv = r.getLeft();
                ISymbol rv = r.getRight(0);
                if (rv instanceof IVariable) {
                    Transition t1 = new Transition(iniMap.get(lv), iniMap.get(rv));
                    Transition t2 = new Transition(finMap.get(rv), finMap.get(lv));
                    transitions.add(t1);
                    transitions.add(t2);
                    break;
                }
                Transition t1 = new Transition(iniMap.get(lv), finMap.get(lv), rv);
                transitions.add(t1);
                break;
            }
            case 2: {
                IVariable lv = r.getLeft();
                ISymbol r0 = r.getRight(0);
                ISymbol r1 = r.getRight(1);
                if (r0 instanceof IVariable) {
                    if (r1 instanceof IVariable) {
                        Transition t0 = new Transition(iniMap.get(lv), iniMap.get(r0));
                        Transition t1 = new Transition(finMap.get(r0), iniMap.get(r1));
                        Transition t2 = new Transition(finMap.get(r1), finMap.get(lv));
                        transitions.add(t0);
                        transitions.add(t1);
                        transitions.add(t2);
                        break;
                    }
                    Transition t0 = new Transition(iniMap.get(lv), iniMap.get(r0));
                    Transition t1 = new Transition(finMap.get(r0), finMap.get(lv), r1);
                    transitions.add(t0);
                    transitions.add(t1);
                    break;
                }
                if (r1 instanceof IVariable) {
                    Transition t0 = new Transition(iniMap.get(lv), iniMap.get(r1), r0);
                    Transition t1 = new Transition(finMap.get(r1), finMap.get(lv));
                    transitions.add(t0);
                    transitions.add(t1);
                    break;
                }
                IState s = sf.createState("s");
                Transition t0 = new Transition(iniMap.get(lv), s, r0);
                Transition t1 = new Transition(s, finMap.get(lv), r1);
                transitions.add(t0);
                transitions.add(t1);
                break;
            }
            default: {
                throw new RuntimeException("size of rule shold be less than 3.: " + r);
            }
        }
    }

    public static IAutomaton toAutomaton(IContextFreeGrammar cfg, MonitorUtil.IProgressMonitor monitor) {
        return RTNRegularApproximation.toAutomaton(cfg, new FreshVariableFactory((ISymbolFactory<IVariable>)SimpleVariableFactory.defaultFactory, cfg), monitor);
    }
}

