/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.regex.string;

import com.ibm.wala.automaton.regex.string.AbstractPatternCompiler;
import com.ibm.wala.automaton.regex.string.ComplementPattern;
import com.ibm.wala.automaton.regex.string.ConcatenationPattern;
import com.ibm.wala.automaton.regex.string.EmptyPattern;
import com.ibm.wala.automaton.regex.string.IntersectionPattern;
import com.ibm.wala.automaton.regex.string.IterationPattern;
import com.ibm.wala.automaton.regex.string.SymbolPattern;
import com.ibm.wala.automaton.regex.string.UnionPattern;
import com.ibm.wala.automaton.regex.string.VariableBindingPattern;
import com.ibm.wala.automaton.regex.string.VariableReferencePattern;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.IEnumerableSymbol;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.automaton.string.StringSymbol;

public class RegexToString
extends AbstractPatternCompiler<String> {
    @Override
    public String onComplement(ComplementPattern pattern) {
        return "(~" + (String)this.compile(pattern.getPattern()) + ")";
    }

    @Override
    public String onConcatenation(ConcatenationPattern pattern) {
        return (String)this.compile(pattern.getHead()) + (String)this.compile(pattern.getTail());
    }

    @Override
    public String onEmpty(EmptyPattern pattern) {
        return "";
    }

    @Override
    public String onIntersection(IntersectionPattern pattern) {
        return (String)this.compile(pattern.getLeft()) + "&" + (String)this.compile(pattern.getRight());
    }

    @Override
    public String onIteration(IterationPattern pattern) {
        String s = (String)this.compile(pattern.getPattern());
        switch (s.length()) {
            case 0: {
                return "";
            }
            case 1: {
                return s + "*";
            }
        }
        return "(" + s + ")*";
    }

    private String charSymbol(IEnumerableSymbol e) {
        if (e instanceof CharSymbol) {
            char c = ((CharSymbol)e).charValue();
            if (!Character.isISOControl(c)) {
                return Character.toString(c);
            }
            return "\\u" + c;
        }
        return "(unknown)";
    }

    @Override
    public String onSymbol(SymbolPattern pattern) {
        ISymbol s = pattern.getSymbol();
        String str = null;
        if (s instanceof StringSymbol) {
            str = ((StringSymbol)s).getName();
        } else if (s instanceof CharSymbol) {
            char c = ((CharSymbol)s).charValue();
            str = !Character.isISOControl(c) ? Character.toString(c) : "\\u" + c;
        } else if (s instanceof RangeSymbol) {
            RangeSymbol r = (RangeSymbol)s;
            str = "[" + this.charSymbol(r.getMin()) + "-" + this.charSymbol(r.getMax()) + "]";
        } else {
            str = "(unknown)";
        }
        return str;
    }

    @Override
    public String onUnion(UnionPattern pattern) {
        String s1 = (String)this.compile(pattern.getLeft());
        String s2 = (String)this.compile(pattern.getRight());
        return "(" + s1 + "|" + s2 + ")";
    }

    @Override
    public String onVariableBinding(VariableBindingPattern pattern) {
        return "(" + (String)this.compile(pattern.getPattern()) + ")";
    }

    @Override
    public String onVariableReference(VariableReferencePattern pattern) {
        return pattern.getVariable().toString();
    }
}

