/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.SingletonGrammar;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.ICharValueSymbol;
import com.ibm.wala.automaton.string.IComparableSymbol;
import com.ibm.wala.automaton.string.IEnumerableSymbol;
import com.ibm.wala.automaton.string.IEnumerableValueSymbol;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IntSymbol;
import com.ibm.wala.automaton.string.NumberSymbol;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.automaton.string.Symbol;
import com.ibm.wala.automaton.string.Variable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class CharSymbol
extends Symbol
implements ICharValueSymbol,
IEnumerableValueSymbol {
    public static Set<ISymbol> ALL_ASCII_CHARS = new HashSet<ISymbol>();
    public static final CharSymbol TOP;
    public static final CharSymbol BOTTOM;
    public static final CharSymbol MIN;
    public static final CharSymbol MAX;

    public CharSymbol(String name) {
        super(name);
        char[] cs = name.toCharArray();
        if (cs.length > 1) {
            throw new AssertionError((Object)"a single character is expected.");
        }
    }

    @Override
    public String toString() {
        String name = super.getName();
        char c = name.charAt(0);
        if (!Character.isISOControl(c)) {
            char l = c;
            return "'" + Character.toString(c) + "(" + Integer.toString(l) + ")'";
        }
        char l = c;
        return "\\u" + Integer.toString(l);
    }

    public CharSymbol(char c) {
        this(Character.toString(c));
    }

    public CharSymbol(byte b) {
        this(Character.toString((char)b));
    }

    @Override
    public Object value() {
        return new Character(this.charValue());
    }

    @Override
    public byte byteValue() {
        return (byte)this.getName().charAt(0);
    }

    @Override
    public char charValue() {
        return this.getName().charAt(0);
    }

    @Override
    public boolean matches(ISymbol symbol, IMatchContext ctx) {
        if (symbol instanceof IEnumerableSymbol) {
            try {
                if (this.compareTo((IEnumerableSymbol)symbol) == 0) {
                    ctx.put(this, symbol);
                    return true;
                }
            }
            catch (IComparableSymbol.NotComparableException notComparableException) {
                // empty catch block
            }
        }
        return super.matches(symbol, ctx);
    }

    public boolean isComparable(IComparableSymbol o) {
        return o instanceof CharSymbol;
    }

    @Override
    public IComparableSymbol[] coerce(IComparableSymbol o) throws IComparableSymbol.NotComparableException {
        if (o instanceof CharSymbol) {
            return new IComparableSymbol[]{o, this};
        }
        if (o instanceof NumberSymbol) {
            NumberSymbol n = (NumberSymbol)o;
            return new IComparableSymbol[]{new IntSymbol(n.intValue()), new IntSymbol(this.charValue())};
        }
        throw new IComparableSymbol.NotComparableException(o, this);
    }

    @Override
    public int compareTo(IComparableSymbol o) throws IComparableSymbol.NotComparableException {
        if (o instanceof CharSymbol) {
            CharSymbol cs = (CharSymbol)o;
            Character c1 = new Character(this.charValue());
            Character c2 = new Character(cs.charValue());
            return c1.compareTo(c2);
        }
        if (o instanceof NumberSymbol) {
            NumberSymbol n = (NumberSymbol)o;
            long d = n.longValue() - (long)this.charValue();
            if (d == 0L) {
                return 0;
            }
            return d > 0L ? 1 : -1;
        }
        IComparableSymbol[] s = o.coerce(this);
        return s[0].compareTo(s[1]);
    }

    @Override
    public int rangeCompareTo(IEnumerableSymbol s) {
        try {
            if (s instanceof CharSymbol) {
                return this.compareTo(s);
            }
            return this.getClass().toString().compareTo(s.getClass().toString());
        }
        catch (IComparableSymbol.NotComparableException e) {
            return this.getClass().toString().compareTo(s.getClass().toString());
        }
    }

    @Override
    public StringSymbol stringSymbolValue() {
        String ch = Character.toString(this.charValue());
        return new StringSymbol(ch);
    }

    @Override
    public IContextFreeGrammar getGrammar() {
        return new SingletonGrammar((IVariable)new Variable("CHAR_SYM#" + this.hashCode()), this);
    }

    @Override
    public IAutomaton getAutomaton() {
        return Automatons.createAutomaton(Arrays.asList(this));
    }

    @Override
    public IEnumerableSymbol getPred() {
        char c = this.charValue();
        if (c == '\u0000') {
            return BOTTOM;
        }
        c = (char)(c - '\u0001');
        return new CharSymbol(c);
    }

    @Override
    public IEnumerableSymbol getSucc() {
        char c = this.charValue();
        if (c == '\uffff') {
            return TOP;
        }
        c = (char)(c + '\u0001');
        return new CharSymbol(c);
    }

    @Override
    public IEnumerableSymbol getMax() {
        return MAX;
    }

    @Override
    public IEnumerableSymbol getMin() {
        return MIN;
    }

    @Override
    public IEnumerableSymbol getTop() {
        return TOP;
    }

    @Override
    public IEnumerableSymbol getBottom() {
        return BOTTOM;
    }

    static {
        for (char c = '\u0000'; c <= '\u007f'; c = (char)(c + '\u0001')) {
            CharSymbol csym = new CharSymbol(c);
            ALL_ASCII_CHARS.add(csym);
        }
        TOP = new CharSymbol('\uffff'){

            @Override
            public IEnumerableSymbol getPred() {
                return MAX;
            }

            @Override
            public IEnumerableSymbol getSucc() {
                return TOP;
            }
        };
        BOTTOM = new CharSymbol('\u0000'){

            @Override
            public IEnumerableSymbol getPred() {
                return BOTTOM;
            }

            @Override
            public IEnumerableSymbol getSucc() {
                return MIN;
            }
        };
        MIN = new CharSymbol('\u0000');
        MAX = new CharSymbol('\uffff');
    }
}

