/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.DMap;
import com.ibm.wala.automaton.string.Automaton;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.FreshStateFactory;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.IStateFactory;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.automaton.string.Transition;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.UnimplementedError;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class Determinization {
    public static IAutomaton determinize(IAutomaton a) {
        return Determinization.determinize(a, null, AUtil.nullProgressMonitor);
    }

    public static IAutomaton determinize(IAutomaton a, IStateFactory sf) {
        return Determinization.determinize(a, sf, AUtil.nullProgressMonitor);
    }

    public static IAutomaton determinize(IAutomaton a, MonitorUtil.IProgressMonitor monitor) {
        return Determinization.determinize(a, null, monitor);
    }

    public static IAutomaton determinize(IAutomaton a, IStateFactory sf, MonitorUtil.IProgressMonitor monitor) {
        Automatons.eliminateEpsilonTransitions(a, monitor);
        if (sf == null) {
            sf = new FreshStateFactory();
        }
        Collection<ISymbol> symbols = Automatons.collectTerminals(a);
        symbols = RangeSymbol.splitSymbols(symbols);
        StateMap smap = new StateMap(sf);
        StateTable tbl = new StateTable();
        HashSet<IState> initSet = new HashSet<IState>();
        initSet.add(a.getInitialState());
        Determinization.makeStateTable(a, initSet, symbols, tbl, smap, monitor);
        HashSet<ITransition> transitions = new HashSet<ITransition>();
        HashSet<IState> finalStates = new HashSet<IState>();
        IState initState = smap.get(initSet);
        Iterator<Object> i = tbl.transitionIterator();
        while (i.hasNext()) {
            ITransition iTransition = i.next();
            transitions.add(iTransition);
        }
        block1: for (Map.Entry entry : smap.entrySet()) {
            for (IState finState : a.getFinalStates()) {
                if (!((HashSet)entry.getKey()).contains(finState)) continue;
                finalStates.add((IState)entry.getValue());
                continue block1;
            }
        }
        Automaton dfa = new Automaton(initState, finalStates, transitions);
        Automatons.eliminateUnreachableStates(dfa);
        Automatons.reduceTransitions(dfa);
        return dfa;
    }

    private static Pair<IState, HashSet<IState>> findState(HashSet<IState> ss, StateTable tbl, StateMap smap) {
        switch (ss.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return Pair.make((Object)ss.iterator().next(), null);
            }
        }
        HashSet ss1 = (HashSet)ss.clone();
        for (IState s : ss) {
            ss1.remove(s);
            IState ns = smap.get(ss1);
            if (tbl.containsKey(ns)) {
                return Pair.make((Object)s, (Object)ss1);
            }
            ss1.add(s);
        }
        return Pair.make(null, (Object)ss1);
    }

    private static void makeStateTable(IAutomaton a, HashSet<IState> ss, Collection<ISymbol> symbols, StateTable tbl, StateMap smap, MonitorUtil.IProgressMonitor monitor) {
        int n = 0;
        int N = 100;
        Stack<HashSet> stack = new Stack<HashSet>();
        stack.push(ss);
        while (!stack.isEmpty()) {
            Pair<IState, HashSet<IState>> p1;
            if (n == N && monitor.isCanceled()) {
                throw CancelRuntimeException.make((String)"determinization");
            }
            int n2 = n = n == N ? 0 : n + 1;
            ss = (HashSet)stack.pop();
            IState pre = smap.get(ss);
            if (tbl.containsKey(pre) || (p1 = Determinization.findState(ss, tbl, smap)) == null) continue;
            IState s1 = (IState)p1.fst;
            HashSet ss1 = (HashSet)p1.snd;
            if (s1 == null) {
                ss1.remove(ss1.iterator().next());
                stack.push(ss);
                stack.push(ss1);
                continue;
            }
            HashSet<HashSet<IState>> nextSets = new HashSet<HashSet<IState>>();
            for (ISymbol iSymbol : symbols) {
                HashSet<IState> dst;
                if (ss1 == null) {
                    dst = new HashSet<IState>();
                } else {
                    IState ns = smap.get(ss1);
                    Map m = (Map)tbl.get(ns);
                    if (m.containsKey(iSymbol)) {
                        IState c = (IState)m.get(iSymbol);
                        dst = (HashSet)smap.rev(c).clone();
                    } else {
                        dst = new HashSet();
                    }
                }
                for (ITransition t : a.getAcceptTransitions(s1, iSymbol)) {
                    dst.add(t.getPostState());
                }
                IState post = smap.get(dst);
                ((Map)tbl.get(pre)).put(iSymbol, post);
                nextSets.add(dst);
            }
            for (HashSet hashSet : nextSets) {
                stack.push(hashSet);
            }
        }
    }

    private static class StateTable
    extends DMap<IState, Map<ISymbol, IState>> {
        private StateTable() {
        }

        @Override
        protected Map<ISymbol, IState> create(IState key) {
            return new HashMap<ISymbol, IState>();
        }

        Iterator<ITransition> transitionIterator() {
            final Iterator i1 = this.entrySet().iterator();
            return new Iterator<ITransition>(){
                Iterator<Map.Entry<ISymbol, IState>> i2 = null;
                IState curState = null;

                @Override
                public boolean hasNext() {
                    if (this.i2 == null || !this.i2.hasNext()) {
                        if (i1.hasNext()) {
                            Map.Entry e = (Map.Entry)i1.next();
                            this.curState = (IState)e.getKey();
                            this.i2 = ((Map)e.getValue()).entrySet().iterator();
                            return this.hasNext();
                        }
                        return false;
                    }
                    return true;
                }

                @Override
                public ITransition next() {
                    Map.Entry<ISymbol, IState> e = this.i2.next();
                    return new Transition(this.curState, e.getValue(), e.getKey());
                }

                @Override
                public void remove() {
                    throw new UnimplementedError();
                }
            };
        }
    }

    private static class StateMap {
        private static final HashSet<IState> emptyHashSet = new HashSet();
        private Map<HashSet<IState>, IState> map;
        private Map<IState, HashSet<IState>> rev;

        public StateMap(final IStateFactory sf) {
            this.map = new DMap<HashSet<IState>, IState>(){

                @Override
                protected IState create(HashSet<IState> key) {
                    return sf.createState(Automatons.prefixState);
                }
            };
            this.rev = new HashMap<IState, HashSet<IState>>();
        }

        public IState dummyState() {
            return this.get(emptyHashSet);
        }

        public boolean containsKey(HashSet<IState> key) {
            return this.map.containsKey(key);
        }

        public void put(HashSet<IState> key, IState value) {
            if (key == null || value == null) {
                throw new RuntimeException();
            }
            this.map.put(key, value);
            this.rev.put(value, key);
        }

        public Set<Map.Entry<HashSet<IState>, IState>> entrySet() {
            return this.map.entrySet();
        }

        public IState get(HashSet<IState> key) {
            IState s = this.map.get(key);
            this.rev.put(s, key);
            return s;
        }

        public HashSet<IState> rev(IState val) {
            return this.rev.get(val);
        }
    }
}

