/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.ITransitionCopier;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.MatchContext;
import com.ibm.wala.automaton.string.Variable;
import com.ibm.wala.automaton.string.VariableReplacer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class Transition
implements ITransition {
    private IState preState = null;
    private IState postState = null;
    private ISymbol inputSymbol = null;
    private List<ISymbol> outputSymbols = new ArrayList<ISymbol>();
    private int hashCode = 0;
    public static final ISymbol EpsilonSymbol = null;

    private Transition() {
    }

    public Transition(IState preState, IState postState, ISymbol inputSymbol, List<? extends ISymbol> outputSymbols) {
        this();
        this.setPreState(preState);
        this.setPostState(postState);
        this.setInputSymbol(inputSymbol);
        if (outputSymbols != null) {
            this.appendOutputSymbols(outputSymbols);
        }
    }

    public Transition(IState preState, IState postState, ISymbol inputSymbol, Iterator<? extends ISymbol> outputSymbols) {
        this(preState, postState, inputSymbol, AUtil.list(outputSymbols));
    }

    public Transition(IState preState, IState postState, ISymbol inputSymbol, ISymbol[] outputSymbols) {
        this(preState, postState, inputSymbol, AUtil.list(outputSymbols));
    }

    public Transition(IState preState, IState postState, ISymbol inputSymbol) {
        this(preState, postState, inputSymbol, (List<? extends ISymbol>)null);
    }

    public Transition(IState preState, IState postState) {
        this(preState, postState, EpsilonSymbol);
    }

    public Transition(ITransition trans) {
        this(trans.getPreState(), trans.getPostState(), trans.getInputSymbol(), trans.getOutputSymbols());
    }

    @Override
    public IState getPreState() {
        return this.preState;
    }

    public void setPreState(IState state) {
        this.preState = state;
    }

    @Override
    public IState getPostState() {
        return this.postState;
    }

    public void setPostState(IState state) {
        this.postState = state;
    }

    @Override
    public ISymbol getInputSymbol() {
        return this.inputSymbol;
    }

    public void setInputSymbol(ISymbol symbol) {
        this.inputSymbol = symbol;
    }

    @Override
    public List<ISymbol> getOutputSymbols() {
        return Collections.unmodifiableList(this.outputSymbols);
    }

    @Override
    public boolean hasOutputSymbols() {
        return !this.outputSymbols.isEmpty();
    }

    public void appendOutputSymbols(List<? extends ISymbol> symbols) {
        this.outputSymbols.addAll(symbols);
    }

    public void prependOutputSymbols(List<? extends ISymbol> symbols) {
        this.outputSymbols.addAll(0, symbols);
    }

    @Override
    public boolean isEpsilonTransition() {
        return this.inputSymbol == EpsilonSymbol;
    }

    @Override
    public boolean accept(ISymbol symbol, IMatchContext ctx) {
        boolean r = this.inputSymbol != null && !(symbol instanceof IVariable) && this.inputSymbol.matches(symbol, ctx);
        return r;
    }

    @Override
    public List<ISymbol> transit(ISymbol symbol) {
        MatchContext ctx = new MatchContext();
        if (this.accept(symbol, ctx)) {
            ctx.put(new Variable("_"), symbol);
            return this.rewrite(this.outputSymbols, ctx);
        }
        return null;
    }

    private List<ISymbol> rewrite(List<ISymbol> symbols, IMatchContext context) {
        ArrayList<ISymbol> result = new ArrayList<ISymbol>();
        for (ISymbol symbol : symbols) {
            result.add(VariableReplacer.replace(symbol, context));
        }
        return result;
    }

    public synchronized int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1 + (this.inputSymbol == null ? 0 : this.inputSymbol.hashCode()) * 13 + this.outputSymbols.hashCode() * 17 + this.preState.hashCode() * 19 + this.postState.hashCode() * 23;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        Transition t = (Transition)obj;
        if (t.hashCode() == this.hashCode()) {
            return (this.inputSymbol == null ? t.inputSymbol == null : this.inputSymbol.equals(t.inputSymbol)) && this.outputSymbols.equals(t.outputSymbols) && this.postState.equals(t.postState) && this.preState.equals(t.preState);
        }
        return false;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        Iterator<ISymbol> i = this.getOutputSymbols().iterator();
        while (i.hasNext()) {
            ISymbol s = i.next();
            buff.append(s.toString());
            if (!i.hasNext()) continue;
            buff.append(", ");
        }
        return this.getPreState().toString() + "(" + this.getInputSymbol() + ") -> " + this.getPostState().toString() + "(" + buff.toString() + ")";
    }

    @Override
    public Object clone() {
        try {
            Transition t = (Transition)super.clone();
            t.outputSymbols = new ArrayList<ISymbol>(t.outputSymbols);
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ITransition copy(ITransitionCopier copier) {
        ITransition t = copier.copy(this);
        if (t instanceof Transition) {
            Transition tt = (Transition)t;
            tt.preState = copier.copyPreState(this, tt.preState);
            tt.postState = copier.copyPostState(this, tt.postState);
            tt.inputSymbol = tt.inputSymbol == null ? null : copier.copyInput(this, tt.inputSymbol);
            tt.outputSymbols = (ArrayList)copier.copyOutput(this, tt.outputSymbols, new ArrayList<ISymbol>());
            tt.hashCode = 0;
        }
        return t;
    }

    public void removeOutputSymbols() {
        this.outputSymbols.clear();
    }

    @Override
    public Collection<ISymbol> getTerminals() {
        HashSet<ISymbol> s = new HashSet<ISymbol>();
        ISymbol inSym = this.getInputSymbol();
        if (inSym != null && !(inSym instanceof IVariable)) {
            s.add(inSym);
        }
        return s;
    }
}

