/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.util.collections;

import com.ibm.wala.automaton.util.collections.IntHashMap;
import com.ibm.wala.automaton.util.collections.SimpleIntSequence;
import com.ibm.wala.automaton.util.collections.TinyOrderdIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class SimpleIntHashMap<T>
implements IntHashMap<T> {
    private static final long serialVersionUID = -1242370704303432866L;
    private final Vector<T> vector;

    public SimpleIntHashMap(int initialCapacity) {
        this.vector = new Vector(initialCapacity);
    }

    public SimpleIntHashMap() {
        this(16);
    }

    @Override
    public boolean containsKey(int key) {
        if (key < 0 || key >= this.vector.size()) {
            return false;
        }
        return this.vector.get(key) != null;
    }

    @Override
    public boolean containsValue(T value) {
        return this.vector.contains(value);
    }

    @Override
    public Set<IntHashMap.Entry<T>> entrySet() {
        IntSet keys = this.keySet();
        IntIterator it = keys.intIterator();
        HashSet<IntHashMap.Entry<T>> s = new HashSet<IntHashMap.Entry<T>>(keys.size());
        while (it.hasNext()) {
            int key = it.next();
            s.add(new EntryImpl(key));
        }
        return s;
    }

    @Override
    public boolean isEmpty() {
        return this.keySet().size() == 0;
    }

    @Override
    public IntSet keySet() {
        SimpleIntSequence validIndices = new SimpleIntSequence(this.vector.size());
        for (int i = 0; i < this.vector.size(); ++i) {
            if (!this.containsKey(i)) continue;
            validIndices.append(i);
        }
        int[] keys = validIndices.toArray();
        return new TinyOrderdIntSet(keys);
    }

    @Override
    public T put(int key, T value) {
        if (key < 0) {
            return null;
        }
        if (key >= this.vector.size()) {
            this.vector.setSize(key + 1);
        }
        return this.vector.set(key, value);
    }

    @Override
    public void putAll(IntHashMap<? extends T> m) {
        for (IntHashMap.Entry<T> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public T remove(int key) {
        if (key < 0 || key >= this.vector.size()) {
            return null;
        }
        T e = this.vector.get(key);
        this.vector.set(key, null);
        return e;
    }

    @Override
    public int size() {
        return this.values().size();
    }

    @Override
    public Collection<T> values() {
        HashSet<T> ret = new HashSet<T>(this.vector.size());
        for (T o : this.vector) {
            if (o == null) continue;
            ret.add(o);
        }
        return ret;
    }

    @Override
    public T get(int key) {
        try {
            return this.vector.get(key);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("{");
        Iterator<IntHashMap.Entry<T>> i = this.entrySet().iterator();
        while (i.hasNext()) {
            IntHashMap.Entry<T> entry = i.next();
            buff.append(entry.getKey() + "=>" + entry.getValue());
            if (!i.hasNext()) continue;
            buff.append(", ");
        }
        buff.append("}");
        return buff.toString();
    }

    protected class EntryImpl
    implements IntHashMap.Entry<T> {
        private final int key;

        protected EntryImpl(int key) {
            this.key = key;
        }

        @Override
        public int getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            return SimpleIntHashMap.this.get(this.key);
        }

        @Override
        public T setValue(T v) {
            return SimpleIntHashMap.this.vector.set(this.key, v);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof IntHashMap.Entry) {
                IntHashMap.Entry e = (IntHashMap.Entry)o;
                return e.getKey() == this.key && e.getValue().equals(this.getValue());
            }
            return false;
        }

        public int hashCode() {
            return this.key;
        }
    }
}

