/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.util.labeledgraph;

import com.ibm.wala.automaton.util.labeledgraph.SimpleEdgeManager;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.graph.AbstractGraph;
import com.ibm.wala.util.graph.EdgeManager;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NodeManager;
import com.ibm.wala.util.graph.impl.BasicNodeManager;
import java.util.Iterator;

public class StandardizedGraph<T, V extends T>
extends AbstractGraph<T> {
    private final Graph<V> original;
    public final T pseudoInitial;
    public final T pseudoFinal;
    private NodeManager<T> nodeManager;
    private EdgeManager<T> edgeManager;

    public StandardizedGraph(Graph<V> delegate, T entry, T exit, T pseudoInitial, T pseudoFinal) {
        this.original = delegate;
        this.pseudoInitial = pseudoInitial;
        this.pseudoFinal = pseudoFinal;
        this.init((Iterator<? extends T>)new NonNullSingletonIterator(entry), (Iterator<? extends T>)new NonNullSingletonIterator(exit));
    }

    public StandardizedGraph(Graph<V> delegate, Iterator<? extends T> entries, Iterator<? extends T> exits, T pseudoInitial, T pseudoFinal) {
        this.original = delegate;
        this.pseudoInitial = pseudoInitial;
        this.pseudoFinal = pseudoFinal;
        this.init(entries, exits);
    }

    private void init(Iterator<? extends T> entries, Iterator<? extends T> exits) {
        T n;
        assert (!this.pseudoInitial.equals(this.pseudoFinal));
        assert (!this.containsNode(this.pseudoInitial));
        assert (!this.containsNode(this.pseudoFinal));
        for (Object n2 : this.original) {
            this.addNode(n2);
            Iterator ns2 = this.original.getSuccNodes(n2);
            while (ns2.hasNext()) {
                Object n22 = ns2.next();
                this.addEdge(n2, n22);
            }
        }
        this.addNode(this.pseudoInitial);
        this.addNode(this.pseudoFinal);
        while (entries.hasNext()) {
            n = entries.next();
            this.addEdge(this.pseudoInitial, n);
        }
        while (exits.hasNext()) {
            n = exits.next();
            this.addEdge(n, this.pseudoFinal);
        }
    }

    protected NodeManager<T> getNodeManager() {
        if (this.nodeManager == null) {
            this.nodeManager = new BasicNodeManager();
        }
        return this.nodeManager;
    }

    protected EdgeManager<T> getEdgeManager() {
        if (this.edgeManager == null) {
            this.edgeManager = new SimpleEdgeManager(this.original.getNumberOfNodes());
        }
        return this.edgeManager;
    }
}

