/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.ruby;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.model.IBuildInfo;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.utils.DirectoryUtil;
import com.ibm.appscan.discovery.dir.CustomFileCollectorStrategy;
import com.ibm.appscan.discovery.ruby.IRubyConstants;
import com.ibm.appscan.discovery.ruby.Messages;
import com.ibm.appscan.internal.discovery.ruby.gem.GemStrategy;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;

public class RubyAppStrategy
extends CustomFileCollectorStrategy
implements IRubyConstants {
    public RubyAppStrategy() {
    }

    public RubyAppStrategy(File directory, Set<IScanFile> scanFiles) {
        this.init(directory, null, scanFiles);
    }

    public String getType() {
        return "ruby_app";
    }

    public String getLanguageType() {
        return "ruby";
    }

    protected boolean shouldVisit(File directory) {
        return !directory.getName().equalsIgnoreCase("vendor") && !directory.getName().equalsIgnoreCase("test") && super.shouldVisit(directory);
    }

    protected String[] getCategories(IBuildInfo buildInfo) {
        return new String[]{"category.ruby"};
    }

    protected String getExtensionGroup() {
        return "ruby";
    }

    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        LinkedHashSet<IScanFile> ret = new LinkedHashSet();
        ret = super.findScanFiles(proxy, progress);
        if (this.getParent() instanceof GemStrategy) {
            try {
                DirectoryUtil.delete((File)((GemStrategy)this.getParent()).getCrawlRoot(proxy));
            }
            catch (IOException e) {
                proxy.getErrorManager().reportError(Messages.getMessage("err.delete.gem.unpacking", new Object[0]), (Throwable)e);
            }
        }
        return ret;
    }
}

