/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.html.jericho;

import com.ibm.wala.cast.ir.translator.TranslatorToCAst;
import com.ibm.wala.cast.js.html.IHtmlCallback;
import com.ibm.wala.cast.js.html.IHtmlParser;
import com.ibm.wala.cast.js.html.jericho.JerichoTag;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.warnings.Warning;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.Set;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Logger;
import net.htmlparser.jericho.LoggerProvider;
import net.htmlparser.jericho.Source;

public class JerichoHtmlParser
implements IHtmlParser {
    static Set<Warning> warnings = HashSetFactory.make();

    @Override
    public void parse(URL url, Reader reader, IHtmlCallback callback, String fileName) throws TranslatorToCAst.Error {
        warnings.clear();
        Parser parser = new Parser(callback, fileName);
        try {
            Source src = new Source(reader);
            src.setLogger(Config.LoggerProvider.getLogger(fileName));
            List childElements = src.getChildElements();
            for (Element e : childElements) {
                parser.parse(e);
            }
            if (!warnings.isEmpty()) {
                throw new TranslatorToCAst.Error(warnings);
            }
        }
        catch (IOException e) {
            System.err.println("Error parsing file: " + e.getMessage());
        }
    }

    static {
        class CAstLoggerProvider
        implements LoggerProvider {
            CAstLoggerProvider() {
            }

            public Logger getLogger(String arg0) {
                class CAstLogger
                implements Logger {
                    CAstLogger() {
                    }

                    public void debug(String arg0) {
                    }

                    public void error(final String arg0) {
                        warnings.add(new Warning(){

                            public String getMsg() {
                                return arg0;
                            }
                        });
                    }

                    public void info(String arg0) {
                    }

                    public boolean isDebugEnabled() {
                        return true;
                    }

                    public boolean isErrorEnabled() {
                        return true;
                    }

                    public boolean isInfoEnabled() {
                        return true;
                    }

                    public boolean isWarnEnabled() {
                        return true;
                    }

                    public void warn(String arg0) {
                    }
                }
                return new CAstLogger();
            }
        }
        Config.LoggerProvider = new CAstLoggerProvider();
    }

    private static class Parser {
        private final IHtmlCallback handler;
        private final String fileName;

        public Parser(IHtmlCallback handler, String fileName) {
            this.handler = handler;
            this.fileName = fileName;
        }

        private void parse(Element root) {
            JerichoTag tag = new JerichoTag(root, this.fileName);
            this.handler.handleStartTag(tag);
            this.handler.handleText(tag.getElementPosition(), (String)tag.getBodyText().snd);
            List childElements = root.getChildElements();
            for (Element child : childElements) {
                this.parse(child);
            }
            this.handler.handleEndTag(tag);
        }
    }
}

