/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ipa.callgraph;

import com.ibm.wala.cast.ipa.callgraph.ArgumentInstanceContext;
import com.ibm.wala.cast.ir.ssa.AstIRFactory;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ssa.IRFactory;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import java.util.HashMap;

public class ObjectSensitivityContextSelector
implements ContextSelector {
    private final ContextSelector base;
    private final HashMap<MethodReference, Boolean> returnsThis_cache = HashMapFactory.make();
    private final IRFactory<IMethod> factory = AstIRFactory.makeDefaultFactory();

    public ObjectSensitivityContextSelector(ContextSelector base) {
        this.base = base;
    }

    private boolean returnsThis(IMethod method) {
        MethodReference mref = method.getReference();
        if (method.getNumberOfParameters() < 1) {
            return false;
        }
        Boolean b = this.returnsThis_cache.get(mref);
        if (b != null) {
            return b;
        }
        for (SSAInstruction inst : this.factory.makeIR(method, (Context)Everywhere.EVERYWHERE, SSAOptions.defaultOptions()).getInstructions()) {
            SSAReturnInstruction ret;
            if (!(inst instanceof SSAReturnInstruction) || (ret = (SSAReturnInstruction)inst).getResult() != 2) continue;
            this.returnsThis_cache.put(mref, true);
            return true;
        }
        this.returnsThis_cache.put(mref, false);
        return false;
    }

    public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey[] arguments) {
        Context baseContext = this.base.getCalleeTarget(caller, site, callee, arguments);
        if (this.returnsThis(callee) && arguments.length > 1 && arguments[1] != null) {
            return new ArgumentInstanceContext(baseContext, 1, arguments[1]);
        }
        return baseContext;
    }

    public IntSet getRelevantParameters(CGNode caller, CallSiteReference site) {
        if (caller.getIR().getCalls(site)[0].getNumberOfUses() > 1) {
            return IntSetUtil.make((int[])new int[]{1}).union(this.base.getRelevantParameters(caller, site));
        }
        return this.base.getRelevantParameters(caller, site);
    }
}

