/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.util;

import com.ibm.wala.cast.js.ssa.PrototypeLookup;
import com.ibm.wala.cast.loader.CAstAbstractLoader;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.warnings.Warning;
import java.util.Iterator;

public class Util {
    public static void checkForFrontEndErrors(IClassHierarchy cha) throws WalaException {
        StringBuffer message = null;
        for (IClassLoader loader : cha.getLoaders()) {
            if (!(loader instanceof CAstAbstractLoader)) continue;
            Iterator errors = ((CAstAbstractLoader)loader).getModulesWithParseErrors();
            if (errors.hasNext()) {
                if (message == null) {
                    message = new StringBuffer("front end errors:\n");
                }
                while (errors.hasNext()) {
                    ModuleEntry errorModule = (ModuleEntry)errors.next();
                    for (Warning w : ((CAstAbstractLoader)loader).getMessages(errorModule)) {
                        message.append("error in ").append(errorModule.getName()).append(":\n");
                        message.append(w.toString()).append("\n");
                    }
                }
            }
            ((CAstAbstractLoader)loader).clearMessages();
        }
        if (message != null) {
            message.append("end of front end errors\n");
            throw new WalaException(String.valueOf(message));
        }
    }

    public static IntSet getArgumentsArrayVns(IR ir, final DefUse du) {
        int size;
        int originalArgsVn = Util.getArgumentsArrayVn(ir);
        final MutableIntSet result = IntSetUtil.make();
        if (originalArgsVn == -1) {
            return result;
        }
        result.add(originalArgsVn);
        do {
            size = result.size();
            result.foreach(new IntSetAction(){

                public void act(int vn) {
                    Iterator insts = du.getUses(vn);
                    while (insts.hasNext()) {
                        SSAInstruction inst = (SSAInstruction)insts.next();
                        if (!(inst instanceof PrototypeLookup) && !(inst instanceof SSAPhiInstruction)) continue;
                        result.add(inst.getDef());
                    }
                }
            });
        } while (size != result.size());
        return result;
    }

    public static int getArgumentsArrayVn(IR ir) {
        for (int i = 0; i < ir.getInstructions().length; ++i) {
            SSAInstruction inst = ir.getInstructions()[i];
            if (inst == null) continue;
            for (int v = 0; v < inst.getNumberOfUses(); ++v) {
                String[] names = ir.getLocalNames(i, inst.getUse(v));
                if (names == null || names.length != 1 || !"arguments".equals(names[0])) continue;
                return inst.getUse(v);
            }
        }
        return -1;
    }
}

