/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.vis;

import com.ibm.wala.analysis.pointers.HeapGraph;
import com.ibm.wala.cast.ipa.callgraph.AstGlobalPointerKey;
import com.ibm.wala.cast.ipa.callgraph.ObjectPropertyCatalogKey;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import com.ibm.wala.viz.viewer.PaPanel;
import java.util.ArrayList;
import java.util.List;

public class JsPaPanel
extends PaPanel {
    private static final long serialVersionUID = 1L;
    private MutableMapping<List<ObjectPropertyCatalogKey>> instanceKeyIdToObjectPropertyCatalogKey = MutableMapping.make();
    private List<AstGlobalPointerKey> globalsPointerKeys = new ArrayList<AstGlobalPointerKey>();
    private String cgNodesRoot = "CGNodes";
    private String globalsRoot = "Globals";

    public JsPaPanel(CallGraph cg, PointerAnalysis<InstanceKey> pa) {
        super(cg, pa);
        this.initDataStructures(pa);
    }

    private void initDataStructures(PointerAnalysis<InstanceKey> pa) {
        HeapGraph heapGraph = pa.getHeapGraph();
        OrdinalSetMapping instanceKeyMapping = pa.getInstanceKeyMapping();
        for (Object n : heapGraph) {
            if (heapGraph.getPredNodeCount(n) != 0) continue;
            if (n instanceof PointerKey) {
                if (n instanceof ObjectPropertyCatalogKey) {
                    ObjectPropertyCatalogKey opck = (ObjectPropertyCatalogKey)n;
                    InstanceKey instanceKey = opck.getObject();
                    int instanceKeyId = instanceKeyMapping.getMappedIndex((Object)instanceKey);
                    JsPaPanel.mapUsingMutableMapping(this.instanceKeyIdToObjectPropertyCatalogKey, (int)instanceKeyId, (Object)opck);
                    continue;
                }
                if (!(n instanceof AstGlobalPointerKey)) continue;
                this.globalsPointerKeys.add((AstGlobalPointerKey)n);
                continue;
            }
            System.err.println("Non Pointer key root: " + n);
        }
    }

    protected List<PointerKey> getPointerKeysUnderInstanceKey(InstanceKey ik) {
        ArrayList<PointerKey> ret = new ArrayList<PointerKey>();
        ret.addAll(super.getPointerKeysUnderInstanceKey(ik));
        int ikIndex = this.pa.getInstanceKeyMapping().getMappedIndex((Object)ik);
        ret.addAll(this.nonNullList((List)this.instanceKeyIdToObjectPropertyCatalogKey.getMappedObject(ikIndex)));
        return ret;
    }

    protected List<Object> getRootNodes() {
        ArrayList<Object> ret = new ArrayList<Object>(2);
        ret.add(this.cgNodesRoot);
        ret.add(this.globalsRoot);
        return ret;
    }

    protected List<Object> getChildrenFor(Object node) {
        ArrayList<Object> ret = new ArrayList<Object>();
        if (node == this.cgNodesRoot) {
            for (int nodeId = 0; nodeId < this.cg.getNumberOfNodes(); ++nodeId) {
                CGNode cgNode = (CGNode)this.cg.getNode(nodeId);
                ret.add(cgNode);
            }
        } else if (node == this.globalsRoot) {
            ret.addAll(this.globalsPointerKeys);
        } else {
            ret.addAll(super.getChildrenFor(node));
        }
        return ret;
    }
}

