/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.plsql;

import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.discovery.dir.BaseCustomCollector;
import com.ibm.appscan.discovery.dir.FileCollectorStrategy;
import com.ibm.appscan.discovery.plsql.IPLSQLConstants;
import com.ibm.appscan.internal.discovery.plsql.PLSQLStrategy;
import java.io.File;
import java.util.Set;

public class PLSQLCollector
extends BaseCustomCollector
implements IPLSQLConstants {
    public PLSQLCollector(File crawlRoot, Set<StringPattern> includes, Set<StringPattern> excludes) {
        super(crawlRoot, includes, excludes);
    }

    public String getType() {
        return "PLSQLCollector";
    }

    protected String getFileExtensionSetName() {
        return "plsql";
    }

    protected boolean acceptFile(File file) {
        if (FileUtil.getFileExtension((File)file).toLowerCase().equals("sf") && file.getParentFile().getName().equalsIgnoreCase("META-INF")) {
            return false;
        }
        return super.acceptFile(file);
    }

    protected ScanTargetStrategy getScanTargetStrategy(ScanTargetStrategy parentStrategy) {
        String root = this.getCrawlRoot().getAbsolutePath();
        if (parentStrategy != null && parentStrategy instanceof FileCollectorStrategy) {
            root = ((FileCollectorStrategy)parentStrategy).getStagingDirectory().getAbsolutePath();
        }
        return new PLSQLStrategy(root, this.getScanFiles());
    }
}

