/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.stage.java;

import com.hcl.clazz.info.ClassInfo;
import com.hcl.clazz.info.ClassNameVisitor;
import com.hcl.irx.stage.StageEventManager;
import com.hcl.irx.stage.java.JavaStager;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.exclude.ExclusionProvider;
import com.ibm.appscan.exclude.exclusions.BaseExclusion;
import com.ibm.appscan.exclude.exclusions.ExclusionException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public abstract class JarAnalyzer {
    private String m_name;
    private boolean m_is_dependency = false;
    private boolean m_has_user_code = false;
    private InputStream m_stream;
    private HashSet<String> m_user_classes = new HashSet();
    private HashSet<String> m_3rd_party_classes_and_extra_files = new HashSet();
    private BaseExclusion m_excluder;
    private JSONObject m_memory_stats;
    private boolean m_has_tld = false;

    public JarAnalyzer(String name, JSONObject memory_stats, InputStream in) throws IOException, ExclusionException {
        this.m_name = name;
        this.m_stream = in;
        this.m_excluder = ExclusionProvider.getExclusion((Language.LANGUAGE)Language.LANGUAGE.JAVA);
        this.m_memory_stats = memory_stats;
    }

    public void processJarFile(boolean isUserExcluded) throws IOException, ExclusionException {
        this.processArchive(isUserExcluded);
        this.tearDownProcess();
        try {
            this.m_memory_stats.put(this.m_name, (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (SystemUtil.isDebug()) {
            System.out.println(this.m_name + " after processArchive used memory:" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L);
        }
    }

    protected void close() {
        IOUtil.close((Closeable)this.m_stream);
    }

    protected void resetStreamToNewStream(InputStream stream) throws IOException {
        IOUtil.close((Closeable)this.m_stream);
        this.m_stream = stream;
    }

    protected abstract void tearDownProcess() throws IOException, ExclusionException;

    public String getNameOfArchive() {
        return this.m_name;
    }

    public InputStream getStream() {
        return this.m_stream;
    }

    public String getFileName() {
        if (this.getNameOfArchive().endsWith(".files")) {
            return this.getNameOfArchive().substring(0, this.getNameOfArchive().lastIndexOf(".files"));
        }
        return this.getNameOfArchive();
    }

    public boolean containsDependencyClasses() {
        return this.m_is_dependency;
    }

    public boolean hasUserCode() {
        return this.m_has_user_code || !JavaStager.isJavaJar(this.getNameOfArchive());
    }

    public boolean hasTldInManifest() {
        return JavaStager.isJavaJar(this.m_name) && this.m_has_tld;
    }

    public HashSet<String> getUserClassesIdentified() {
        return this.m_user_classes;
    }

    public HashSet<String> get3rdPartyClassesAndExtraFilesIdentified() {
        return this.m_3rd_party_classes_and_extra_files;
    }

    private void processArchive(boolean isUserExcluded) throws IOException, ExclusionException {
        ZipEntry entry;
        ZipInputStream stream = null;
        stream = new ZipInputStream(this.m_stream);
        if (!JavaStager.isJavaJar(this.getFileName())) {
            this.m_has_user_code = true;
        }
        while ((entry = stream.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            if (JavaStager.isJavaClass(entry.getName())) {
                if (JavaStager.isJavaJar(this.getNameOfArchive())) {
                    ClassNameVisitor cn = new ClassNameVisitor((InputStream)stream);
                    if (isUserExcluded || this.m_excluder.isExcluded(cn.getClassName())) {
                        this.m_3rd_party_classes_and_extra_files.add(entry.getName());
                        continue;
                    }
                    this.m_has_user_code = true;
                    this.m_user_classes.add(entry.getName());
                    continue;
                }
                ClassInfo ca = new ClassInfo(JavaStager.getDataFromStream(stream), entry.toString());
                if (StageEventManager.fireStageClassInfoEvent(ca)) {
                    this.m_has_user_code = true;
                    continue;
                }
                if (JavaStager.isJavaJar(this.getFileName())) continue;
                StageEventManager.fireStageLooseClassInfoEvent(ca);
                continue;
            }
            if (JavaStager.isSmapFile(entry.getName())) {
                String name = entry.getName();
                if (name.startsWith("WEB-INF/classes")) {
                    name = name.substring(name.indexOf("WEB-INF/classes") + 16).replaceAll("/", ".");
                }
                StageEventManager.fireStageSmapFileEvent(new File(this.getNameOfArchive(), name), stream);
                this.m_has_user_code = true;
                continue;
            }
            if (JavaStager.isJsp(entry.getName())) {
                if (isUserExcluded && this.m_excluder.isExcluded(entry.getName().replaceAll("/", "."))) continue;
                StageEventManager.fireStageJspFileEvent(this.getNameOfArchive(), entry.getName(), stream);
                this.m_has_user_code = true;
                continue;
            }
            if (JavaStager.isJavaCompressedFile(entry.getName())) {
                String id = this.m_name + ".child/" + entry.getName();
                StageEventManager.fireStageInternalJavaCompressedFileEvent(id, entry, stream);
                continue;
            }
            if (JavaStager.isTld(entry.getName())) {
                this.m_has_tld = true;
                if (!JavaStager.isJavaWebArchive(this.getNameOfArchive())) continue;
                StageEventManager.fireStageExtraFileEvent(this.getNameOfArchive(), entry.getName(), stream);
                continue;
            }
            this.m_3rd_party_classes_and_extra_files.add(entry.getName());
        }
    }
}

