/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.stage.java;

import com.hcl.clazz.info.ClassInfo;
import com.hcl.irx.stage.Messages;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.validation.IValidationIssue;
import com.ibm.appscan.common.model.validation.MissingDependency;
import com.ibm.appscan.common.model.validation.ThreadedTargetValidator;
import com.ibm.appscan.common.utils.ClasspathUtil;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.exclude.ExclusionProvider;
import com.ibm.appscan.exclude.exclusions.BaseExclusion;
import com.ibm.appscan.exclude.exclusions.ExclusionException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.util.ClassPath;

public class JavaTargetValidator
extends ThreadedTargetValidator {
    private ClassPath m_classpath;

    public JavaTargetValidator(Set<IScanFile> scan_files, IScanTargetMinProxy proxy) {
        super(scan_files, proxy);
    }

    public JavaTargetValidator(Collection<File> files, IScanTargetMinProxy proxy) {
        super(files, proxy);
    }

    protected Runnable getWorkerThread(File file) {
        final File scanFile = file;
        return new Runnable(){

            @Override
            public void run() {
                try {
                    HashSet<MissingDependency> issues = new HashSet<MissingDependency>();
                    ClassInfo classInfo = new ClassInfo(scanFile);
                    try {
                        BaseExclusion exclusionProvider = ExclusionProvider.getExclusion((Language.LANGUAGE)Language.LANGUAGE.JAVA);
                        if (exclusionProvider != null && exclusionProvider.isPackageExcluded(classInfo.getPackageName())) {
                            return;
                        }
                    }
                    catch (ExclusionException e) {
                        JavaTargetValidator.this.logMessage(new Message(Messages.getMessage("error.checking.exclusions", classInfo.getPackageName()), (Throwable)e));
                    }
                    for (String dependentClass : classInfo.getDependentClasses()) {
                        if (dependentClass.contains("$")) {
                            dependentClass = dependentClass.substring(0, dependentClass.indexOf("$"));
                        }
                        try {
                            JavaTargetValidator.this.m_classpath.getClassFile(dependentClass);
                        }
                        catch (IOException e) {
                            String missingRef = dependentClass.lastIndexOf(".") == -1 ? dependentClass : dependentClass.substring(0, dependentClass.lastIndexOf(".") + 1) + "*";
                            issues.add(new MissingDependency(scanFile, new File(missingRef), IValidationIssue.SEVERITY.MAJOR));
                        }
                    }
                    JavaTargetValidator.this.addValidationIssues(scanFile, issues);
                }
                catch (IOException | IndexOutOfBoundsException e) {
                    JavaTargetValidator.this.logMessage(new Message(Messages.getMessage("error.checking.refs", scanFile.getName()), (Throwable)e));
                }
            }
        };
    }

    protected void setup() {
        String classpath = this.getProxy().getBuildInfo().getProperty("classpath");
        String additionalClasspath = this.getProxy().getBuildInfo().getProperty("additional_classpath");
        String bootstrapClasspath = this.getProxy().getBuildInfo().getProperty("bootstrap_classpath");
        String extensionJars = this.getProxy().getBuildInfo().getProperty("extension_jars");
        String securityAnnotationsJar = CommonCore.getDirectoryLocator().getAnnotation();
        String combinedClasspath = ClasspathUtil.joinPaths((String[])new String[]{classpath, extensionJars, bootstrapClasspath, additionalClasspath, securityAnnotationsJar});
        this.m_classpath = new ClassPath(combinedClasspath);
    }

    protected void cleanup() {
        IOUtil.close((Closeable)this.m_classpath);
    }
}

