/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.config;

import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.internal.config.LogMergerScanManifest;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class LogMergerScanManifestJson
extends LogMergerScanManifest {
    public LogMergerScanManifestJson(File destination, IScan scan) throws IOException {
        super(destination, scan);
    }

    @Override
    protected String getNewFileName(String supplied_name) {
        return "scan.manifest.json";
    }

    @Override
    protected void saveFile() {
        try {
            JSONObject manifest = new JSONObject();
            JSONObject languages = new JSONObject();
            languages.put("count", this.getLanguageCountWithScanFiles());
            for (String key : this.getLanguageFileMap().keySet()) {
                if (this.getLanguageFileMap().get(key).size() <= 0) continue;
                JSONObject lang = new JSONObject();
                lang.put("name", (Object)key);
                lang.put("count", this.getLanguageFileMap().get(key).size());
                TreeMap<String, IScanFile> sortedScanFileMap = new TreeMap<String, IScanFile>();
                for (IScanFile iScanFile : this.getLanguageFileMap().get(key)) {
                    sortedScanFileMap.put(this.getPathFromScanFile(iScanFile), iScanFile);
                }
                for (Map.Entry entry : sortedScanFileMap.entrySet()) {
                    JSONObject file = new JSONObject();
                    file.put("file", (Object)((IScanFile)entry.getValue()).getSourcePath());
                    file.put("file_version", (Object)((IScanFile)entry.getValue()).getFileVersion());
                    file.put("size_kb", (Object)String.format("%.1f", ((IScanFile)entry.getValue()).getFileSize()));
                    lang.append("files_to_analyze", (Object)file);
                }
                languages.append("language", (Object)lang);
            }
            manifest.put("languages", (Map)languages);
            JSONObject optionsJson = new JSONObject();
            for (Map.Entry<String, String> entry : this.getIRGenOptions().entrySet()) {
                optionsJson.put(entry.getKey(), (Object)entry.getValue());
            }
            manifest.put("scan_options", (Map)optionsJson);
            IOUtil.write((String)manifest.toString(true), (File)this.getMergedFile());
        }
        catch (IOException e) {
            this.getLogManager().log((Exception)e);
        }
        catch (JSONException e) {
            this.getLogManager().log((Exception)((Object)e));
        }
    }
}

