/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.shrikeCT.tools;

import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.Disassembler;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.MethodEditor;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.analysis.Verifier;
import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.Writer;

public class MethodTracer {
    private static final boolean disasm = true;
    private static final boolean verify = true;
    private static final boolean INSTRUMENT_CALLERS = false;
    private static OfflineInstrumenter instrumenter;
    static final Instruction getSysErr;
    static final Instruction callPrintln;

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 1; ++i) {
            ClassInstrumenter ci;
            instrumenter = new OfflineInstrumenter(true);
            BufferedWriter w = new BufferedWriter(new FileWriter("report", false));
            instrumenter.parseStandardArgs(args);
            instrumenter.setPassUnmodifiedClasses(false);
            instrumenter.beginTraversal();
            while ((ci = instrumenter.nextClass()) != null) {
                MethodTracer.doClass(ci, w);
            }
            instrumenter.close();
        }
    }

    private static void doClass(ClassInstrumenter ci, Writer w) throws Exception {
        w.write("Class: " + ci.getReader().getName() + "\n");
        w.flush();
        for (int i = 0; i < ci.getReader().getMethodCount(); ++i) {
            MethodData d = ci.visitMethod(i);
            if (d == null) continue;
            w.write("Instrumenting " + ci.getReader().getMethodName(i) + " " + ci.getReader().getMethodType(i) + ":\n");
            w.flush();
            w.write("Initial ShrikeBT code:\n");
            new Disassembler(d).disassembleTo(w);
            w.flush();
            Verifier v = new Verifier(d);
            v.verify();
            MethodEditor me = new MethodEditor(d);
            me.beginPass();
            final String msg0 = "Call to " + Util.makeClass("L" + ci.getReader().getName() + ";") + "." + ci.getReader().getMethodName(i);
            me.insertAtStart(new MethodEditor.Patch(){

                @Override
                public void emitTo(MethodEditor.Output w) {
                    w.emit(getSysErr);
                    w.emit(ConstantInstruction.makeString(msg0));
                    w.emit(callPrintln);
                }
            });
            me.applyPatches();
            w.write("Final ShrikeBT code:\n");
            new Disassembler(d).disassembleTo(w);
            w.flush();
            Verifier v2 = new Verifier(d);
            v2.verify();
        }
        if (ci.isChanged()) {
            instrumenter.outputModifiedClass(ci);
        }
    }

    static {
        getSysErr = Util.makeGet(System.class, "err");
        callPrintln = Util.makeInvoke(PrintStream.class, "println", new Class[]{String.class});
    }
}

