/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.sourcepos;

import com.ibm.wala.sourcepos.CRTData;
import com.ibm.wala.sourcepos.Debug;
import com.ibm.wala.sourcepos.InvalidCRTDataException;
import com.ibm.wala.sourcepos.PositionsAttribute;
import com.ibm.wala.sourcepos.Range;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.LinkedList;

public final class CRTable
extends PositionsAttribute {
    public static final String ATTRIBUTE_NAME = "CharacterRangeTable";
    private static final String WARN_CRT_ENTRIES_CONTRADICTORY = "CRT entries %1$s and %2$s are contradictory.";
    private static final String ERR_NO_CRT_ENTRY = "No CRT entry found for program counter %1$s.";
    private CRTData[] crt;

    public CRTable(byte[] data) throws IOException {
        super(data);
    }

    @Override
    protected final void readData(DataInputStream in) throws IOException {
        assert (in != null);
        int crt_length = in.readShort();
        this.crt = new CRTData[crt_length];
        for (int i = 0; i < crt_length; ++i) {
            short pc_start_index = in.readShort();
            short pc_end_index = in.readShort();
            int source_start_position = in.readInt();
            int source_end_position = in.readInt();
            short flags = in.readShort();
            try {
                this.crt[i] = new CRTData(pc_start_index, pc_end_index, source_start_position, source_end_position, flags);
                continue;
            }
            catch (InvalidCRTDataException e) {
                LinkedList<Object> l = e.getData();
                if (l == null) {
                    l = new LinkedList();
                }
                l.addFirst(i);
                Debug.warn(e.getMessage(), l.toArray());
            }
        }
    }

    public final Range getSourceInfo(int pc) {
        CRTData sourceInfo;
        block5: {
            sourceInfo = null;
            int sourceInfoIndex = 0;
            for (int i = 0; i < this.crt.length; ++i) {
                if (this.crt[i] == null || !this.crt[i].isInRange(pc)) continue;
                if (sourceInfo != null && !sourceInfo.matches(this.crt[i])) {
                    Debug.warn(WARN_CRT_ENTRIES_CONTRADICTORY, sourceInfoIndex, i);
                }
                if (sourceInfo != null && !this.crt[i].isMorePrecise(sourceInfo)) continue;
                sourceInfo = this.crt[i];
                sourceInfoIndex = i;
            }
            if (sourceInfo == null) {
                Debug.error(ERR_NO_CRT_ENTRY, pc);
                try {
                    short short_pc = (short)(pc & 0xFFFF);
                    sourceInfo = new CRTData(short_pc, short_pc, 0, 0, 512);
                }
                catch (InvalidCRTDataException e) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
        }
        return sourceInfo.getSourceInfo();
    }

    public String toString() {
        if (this.crt == null) {
            return "<undefined>";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.crt.length; ++i) {
            sb.append(i + " -> ");
            sb.append(this.crt[i] == null ? "<null>" : this.crt[i]);
            sb.append("\n");
        }
        return sb.toString();
    }
}

