/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.markup.trainer;

import com.ibm.appscan.ica.markup.MarkupException;
import com.ibm.appscan.ica.markup.data.MarkupActiveFeatures;
import com.ibm.appscan.ica.markup.trainer.MarkupTrainer;
import com.ibm.appscan.ifa.common.IfaException;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.markup.ao.ActionObject;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.rule.BaseLogicGate;
import com.ibm.appscan.vdb.rule.Rule;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class SinkVulnTrainer
extends MarkupTrainer {
    @Override
    public String getClassFromIndex(int index) throws MarkupException {
        return this.getIdMap().get(index);
    }

    @Override
    public boolean hasMarkup(Method m) {
        return m.getSinks().size() > 0;
    }

    @Override
    public String predict_(Method m) throws MarkupException {
        try {
            LinkedHashMap probabilities = this.getModel().getSortedProbabilities(this.getVector(this.getTestMethod(m)));
            Iterator iterator = probabilities.keySet().iterator();
            while (iterator.hasNext()) {
                double key = (Double)iterator.next();
                if (!((Double)probabilities.get(key) > 0.9)) continue;
                return this.getIdMap().get((int)key);
            }
            return "Vulnerability.Validation.Required";
        }
        catch (IfaException e) {
            throw new MarkupException(e);
        }
    }

    @Override
    public String getMarkupString(Method m) throws MarkupException {
        return this.hasMarkup(m) ? ((ActionObject)m.getSinks().get(0)).getVulnerability() : "0";
    }

    @Override
    protected MarkupActiveFeatures.MARKUP_FEATURES getFeature() {
        return MarkupActiveFeatures.MARKUP_FEATURES.VULN_TYPE;
    }

    @Override
    public String getMarkupFromRule(Method m) throws MarkupException {
        for (Rule r : this.getRules()) {
            if (!r.isMatch(m)) continue;
            return r.getActionObjectRule().getVulnerability();
        }
        return null;
    }

    @Override
    protected void initRules() throws BadRuleException, MarkupException {
        Rule r = new Rule();
        r.setRuleName("Logging Forge");
        BaseLogicGate g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        Rule r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("log");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("LogMessage");
        r2 = g.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("log");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("info");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("severe");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("logp");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("logrb");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("fine");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("finer");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("finest");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("warning");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("WriteLogRecord");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("zendlog");
        r2 = g.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getClassRule().setRuleValue("log");
        r2 = g.createRule();
        r2.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getPackageRule().setRuleValue("log4j");
        r.getActionObjectRule().setVulnerability("Vulnerability.Logging.Forge");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("PrintWriter.print");
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r.getMethodRule().getSignatureRule().setRuleValue("print");
        r.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r.getMethodRule().getClassRule().setRuleValue("print");
        r.getActionObjectRule().setVulnerability("Vulnerability.Validation.Required");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Privacy Data Leakage");
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r.getMethodRule().getSignatureRule().setRuleValue("transmitEvent");
        r.getActionObjectRule().setVulnerability("Vulnerability.Privacy.DataLeakage");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Login - Authentication");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("login");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("logout");
        r.getActionObjectRule().setVulnerability("Vulnerability.Authentication");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Unprotected Credentials");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("ChangePassword");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("resetPassword");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setUserSid");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("setPassword");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("setHttpsCertPassphrase");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("LogonUser");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("NetworkCredential");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("import");
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("x509");
        r2 = g.createRule();
        BaseLogicGate g2 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        Rule r3 = g2.createRule();
        r3.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r3.getMethodRule().getSignatureRule().setRuleValue("set");
        r3 = g2.createRule();
        BaseLogicGate g3 = r3.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        Rule r4 = g3.createRule();
        r4.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
        r4.getMethodRule().getSignatureRule().setRuleValue("passwd");
        r4 = g3.createRule();
        r4.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
        r4.getMethodRule().getSignatureRule().setRuleValue("password");
        r4 = g3.createRule();
        r4.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
        r4.getMethodRule().getSignatureRule().setRuleValue("username");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("addAccountExplicitly");
        r.getActionObjectRule().setVulnerability("Vulnerability.Authentication.Credentials.Unprotected");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("PathTraversal");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setInstallDir");
        r2 = g.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getClassRule().setRuleValue("FileReader");
        r2 = g.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("directory");
        r2 = g.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("filemodel");
        r2 = g.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getClassRule().setRuleValue("getFileInputStream");
        r2 = g.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getClassRule().setRuleValue("FileReader");
        r2 = g.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getClassRule().setRuleValue("RandomAccessFile");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("PathSeparator");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("renamefile");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setdir");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setselectedfile");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setcurrentdir");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("createnewfolder");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("mkdir");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("CreateDirectory");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setFileName");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setpathName");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("directory");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("ftw");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setPath");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("open");
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("zip");
        r2 = g.createRule();
        r2.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_CONSTRUCTOR);
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("zip");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("initWithContentsOfURL");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setdestination");
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("file");
        r.getActionObjectRule().setVulnerability("Vulnerability.PathTraversal");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Vulnerability.Validation.Required.URL");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setAnchor");
        r2 = g.createRule();
        r2.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getArgumentRule().setRuleValue("url");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setUrl");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setHref");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setNewFeedUrl");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("WebProxy");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setUrn");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setstarturl");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setTargetEndpointAddress");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setCommentURL");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("writeToURI");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("setImgUrl");
        r2 = g.createRule();
        r2.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getArgumentRule().setRuleValue("$uri");
        r2 = g.createRule();
        g2 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("set");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("uri");
        r2 = g.createRule();
        g2 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("set");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("url");
        r2 = g.createRule();
        g2 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("get");
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("Http");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("async");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setDocumentUri");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("seturi");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("fromurl");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("AddHookChannelUri");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("URLString");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setParentUri");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("HttpWebRequest");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("HttpWebResponse");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("download");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setWebServiceUrl");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setCreatedFromReportUri");
        r2 = g.createRule();
        r2.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getArgumentRule().setRuleValue("System.Uri");
        r2.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
        r2.getMethodRule().getArgCountRule().setArgCountValue(1);
        r2 = g.createRule();
        g2 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r2 = g2.createRule();
        g3 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g3.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("open");
        r2 = g3.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("upload");
        r2 = g3.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("execute");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("PutAsync");
        r2.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getArgumentRule().setRuleValue("url");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("PostAsync");
        r2.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getArgumentRule().setRuleValue("url");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("SendAsync");
        r2.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getArgumentRule().setRuleValue("url");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("deleteasync");
        r2 = g2.createRule();
        g3 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g3.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("web");
        r2 = g3.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("http");
        r.getActionObjectRule().setVulnerability("Vulnerability.Validation.Required.URL");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("XSS");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("addHeader");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setUrlAndVisibleRect");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("createresponse");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("HTMLBody");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setHeaderText");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setHtml");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("write");
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("css");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("print");
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getClassRule().setRuleValue("JspWriter");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("path");
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("writecookie");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setValue");
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getClassRule().setRuleValue("ListBox");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("default");
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("Cookie");
        r2 = g.createRule();
        g2 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("createfor");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("http");
        r2 = g.createRule();
        g2 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r2 = g2.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("html");
        r2 = g2.createRule();
        g2 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setcolgroup");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setCaption");
        r2 = g.createRule();
        g2 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r2 = g2.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("http");
        r2 = g2.createRule();
        g2 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("post");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("construct");
        r.getActionObjectRule().setVulnerability("Vulnerability.CrossSiteScripting");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("URL Redirect");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("redirect");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("setredirect");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("sendRedirect");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("gotoUrl");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("Navigate");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setResponseLocation");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("transfer");
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("http");
        r.getActionObjectRule().setVulnerability("Vulnerability.Validation.Required.URL.Redirect");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("SQLi");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("executeQuery");
        r2 = g.createRule();
        r2.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getPackageRule().setRuleValue("sql");
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("execute");
        r2 = g.createRule();
        r2.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getPackageRule().setRuleValue("dbconnection");
        g2 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("execute");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("insert");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("update");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("delete");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("select");
        r2 = g.createRule();
        r2.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getPackageRule().setRuleValue("jdbc");
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("execute");
        r2 = g.createRule();
        r2.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getPackageRule().setRuleValue("jdbc");
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("query");
        r2 = g.createRule();
        r2.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getPackageRule().setRuleValue("jdbc");
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("batch");
        r2 = g.createRule();
        r2.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getPackageRule().setRuleValue("sql");
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("update");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setDeleteCommand");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setInsertCommand");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("execSQL");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setSql");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("SelectCommand");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("concatenateWhere");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("createNativeQuery");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("ora_parse");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("addBatch");
        r2.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getPackageRule().setRuleValue("sql");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("UpdateCommand");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("SqlQuery");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("OpenTable");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("addrecord");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("unbufferedQuery");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("AdomdCommand");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("AdomdDataAdapter");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("BusinessLogicCommand");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("FindPrevious");
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("recordset");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setCommandText");
        r2 = g.createRule();
        g2 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g2.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("adodb");
        r2 = g2.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("DbCommand");
        r2 = g2.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("BusinessLogicCommand");
        r2 = g.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("adodb");
        r2 = g2.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("recordset");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("appendWhere");
        r.getActionObjectRule().setVulnerability("Vulnerability.Injection.SQL");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Injection");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("onTransact");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setRenderParameter");
        r2 = g.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getClassRule().setRuleValue("UnsafeNativeMethods");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("serialize");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("ContentType");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("addfile");
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("http");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setIncludePath");
        r.getActionObjectRule().setVulnerability("Vulnerability.Injection");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Priv escalation");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("loadLibrary");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("execv");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("ShellExecute");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("serialize");
        r.getActionObjectRule().setVulnerability("Vulnerability.PrivilegeEscalation");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Regex Injection");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("initWithPattern");
        r2 = g.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("matcher");
        r.getActionObjectRule().setVulnerability("Vulnerability.Injection.RegEx");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Second Order Injection");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r2 = g.createRule();
        g2 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g2.createRule();
        r2.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getPackageRule().setRuleValue("sql");
        r2 = g2.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("sql");
        r2 = g.createRule();
        g2 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setobject");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setclob");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setblob");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setstring");
        r.getActionObjectRule().setVulnerability("Vulnerability.Injection.SecondOrder");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Vulnerability.Quality.TestCode");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("write");
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("console");
        r.getActionObjectRule().setVulnerability("Vulnerability.Quality.TestCode");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Injection DBConnectionString");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("SqlConnection");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setConnectionString");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setConnectionString");
        r.getActionObjectRule().setVulnerability("Vulnerability.Injection.DBConnectionString");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Hidden Field");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setValue");
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("hiddenField");
        r.getActionObjectRule().setVulnerability("Vulnerability.Validation.Required.HiddenFields");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("DBConnectionString Manipulation");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        g2 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r2 = g2.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("db");
        r2 = g2.createRule();
        g2 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setItem");
        r2 = g.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("OdbcConnectionStringBuilder");
        r2 = g.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("OleDbConnectionStringBuilder");
        r2 = g.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("SqlConnectionStringBuilder");
        r.getActionObjectRule().setVulnerability("Vulnerability.Validation.Required.DBConnectionStringManipulation");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("WriteToStream");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("Write");
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("stream");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("Write");
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("BinaryWriter");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("Write");
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("TextWriter");
        r.getActionObjectRule().setVulnerability("Vulnerability.Validation.Required.WriteToStream");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Vulnerability.Validation.Required.URL.Domain");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getClassRule().setRuleValue("ping");
        r.getActionObjectRule().setVulnerability("Vulnerability.Validation.Required.URL.Domain");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Malicious.DynamicCode.Construction");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getClassRule().setRuleValue("Compiler");
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("write");
        r.getActionObjectRule().setVulnerability("Vulnerability.Malicious.DynamicCode.Construction");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Malicious.DynamicCode.Execution");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("Invoke");
        r.getActionObjectRule().setVulnerability("Vulnerability.Malicious.DynamicCode.Execution");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("XML injection");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("WriteXml");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("saveXml");
        r2 = g.createRule();
        g2 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r2 = g2.createRule();
        g3 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g3.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("xml");
        r2 = g3.createRule();
        r2.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getPackageRule().setRuleValue("xml");
        r2 = g2.createRule();
        g2 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("value");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("write");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setData");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setInnerXml");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("append");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("comment");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("namespace");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("source");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("name");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("prefix");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("language");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("schema");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("public");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("system");
        r.getActionObjectRule().setVulnerability("Vulnerability.Injection.XML");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Write to socket");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getClassRule().setRuleValue("socket");
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("send");
        r.getActionObjectRule().setVulnerability("Vulnerability.Validation.Required.WriteToSocket");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Vulnerability.Validation.Required.URL.Port");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getClassRule().setRuleValue("socket");
        r2 = g.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getClassRule().setRuleValue("TcpClient");
        r.getActionObjectRule().setVulnerability("Vulnerability.Validation.Required.URL.Port");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("AppDos");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("Fields");
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("delete");
        r.getActionObjectRule().setVulnerability("Vulnerability.AppDOS");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("HTTP Response Splitting");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setHeader");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setDateHeader");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("addDateHeader");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setIntHeader");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("addIntHeader");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setRawHeader");
        r.getActionObjectRule().setVulnerability("Vulnerability.Injection.HttpResponseSplitting");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Vulnerability.SessionManagement.Cookies");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setcookie");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("set$cookie");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setname");
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("cookie");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setvalue");
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("cookie");
        r.getActionObjectRule().setVulnerability("Vulnerability.SessionManagement.Cookies");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Access Control Bypass");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setPermissionSet");
        r2 = g.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("FilePermission");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("serverrights");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("chperm");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("zendacl");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("addserver");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setPrivilege");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("setDocumentAccessPermission");
        r.getActionObjectRule().setVulnerability("Vulnerability.AccessControl.Bypass");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("OS Injection");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("ftpexec");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setCommandLine");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("Start");
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("process");
        r.getActionObjectRule().setVulnerability("Vulnerability.Injection.OS");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Phishing Email");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("AddAttachment");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("Attachment");
        r.getActionObjectRule().setVulnerability("Vulnerability.Phishing.Email");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Injection Email");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("setEmail");
        r2 = g.createRule();
        g2 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r2 = g2.createRule();
        g3 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("mail");
        r2 = g3.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("message");
        r2 = g2.createRule();
        g2 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("CC");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("from");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setto");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setEmailAddress");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("setReplyTo");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setbody");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("sender");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setemail");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setcontent");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("writeheader");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("subject");
        r.getActionObjectRule().setVulnerability("Vulnerability.Injection.Mail");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Injection Xpath");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setXpath");
        r2 = g.createRule();
        g2 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r2 = g2.createRule();
        g3 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g3.createRule();
        r2.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getClassRule().setRuleValue("xpath");
        r2 = g3.createRule();
        r2.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getPackageRule().setRuleValue("xpath");
        r2 = g2.createRule();
        g2 = r2.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("evaluate");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("matches");
        r2 = g2.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("select");
        r.getActionObjectRule().setVulnerability("Vulnerability.Injection.XPath");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Access Control");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("addRole");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("chmod");
        r.getActionObjectRule().setVulnerability("Vulnerability.AccessControl");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Buffer Overflow");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r2.getMethodRule().getSignatureRule().setRuleValue("bcopy");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("strxfrm");
        r.getActionObjectRule().setVulnerability("Vulnerability.BufferOverflow");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("Buffer Overflow Format String");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("setproctitle");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r2.getMethodRule().getSignatureRule().setRuleValue("vwarnx");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("printf");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("syslog");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("scanf");
        r2 = g.createRule();
        r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r2.getMethodRule().getSignatureRule().setRuleValue("errc");
        r.getActionObjectRule().setVulnerability("Vulnerability.BufferOverflow.FormatString");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("exception with string");
        r.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r.getMethodRule().getClassRule().setRuleValue("exception");
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r.getMethodRule().getSignatureRule().setRuleValue("init");
        r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r.getMethodRule().getArgumentRule().setRuleValue("string");
        r.getActionObjectRule().setVulnerability("Vulnerability.ErrorHandling");
        this.getRules().add(r);
    }

    @Override
    protected void applyMarkup(Method m, String markupString) throws MarkupException, BadMarkupException {
    }

    @Override
    protected void initAntiRules() throws MarkupException {
    }

    @Override
    protected String getMarkupType() {
        return "sink_vuln";
    }

    @Override
    public boolean useNoMarkupMethods() {
        return false;
    }

    @Override
    protected String getAntiMatch() {
        return null;
    }
}

