/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.markup.translator;

import com.ibm.appscan.ica.markup.MarkupException;
import com.ibm.appscan.ica.markup.translator.MarkupTranslator;
import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.appscan.vdb.rule.BaseLogicGate;
import com.ibm.appscan.vdb.rule.Rule;

public class SourceTranslator
extends MarkupTranslator {
    public static String NOT_SOURCE = "Not Source";
    public static String SOURCE = "Source";

    @Override
    public String getMarkupString(Method m) throws MarkupException {
        if (m.getSources().size() > 0) {
            return SOURCE;
        }
        return NOT_SOURCE;
    }

    @Override
    public boolean hasMarkup(Method m) {
        return m.getSources().size() > 0;
    }

    @Override
    public boolean applyMarkup(Method m, String markupString) throws MarkupException {
        if (markupString.equals(NOT_SOURCE)) {
            return false;
        }
        if (!m.isReturn() && m.getArgs().size() == 0) {
            return false;
        }
        try {
            if (!VdbProvider.isTaintPossible((Method)m)) {
                return false;
            }
            if (m.isReturn() && VdbProvider.isTaintType((String)m.getReturn())) {
                m.addSource("none", true);
            } else {
                String args = this.getArgsForSource(m);
                if (args.equals("none")) {
                    return false;
                }
                m.addSource(args, false);
            }
            return true;
        }
        catch (VDBException e) {
            return false;
        }
    }

    private String getArgsForSource(Method m) throws VDBException {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < m.getArgs().size(); ++i) {
            if (!VdbProvider.isTaintType((String)m.getSimpleArgString(i)) || ((String)m.getArgs().get(i)).equals("android.content.Context")) continue;
            str.append(i + 1 + ",");
        }
        if (str.length() > 0) {
            str.deleteCharAt(str.length() - 1);
        }
        if (str.length() == 0) {
            return "none";
        }
        return str.toString();
    }

    @Override
    public boolean useOnlyMarkedUpMethods() {
        return false;
    }

    @Override
    protected String getMarkupType() {
        return "source";
    }

    @Override
    public String convertRuleToMarkup(Method m) throws MarkupException {
        if (this.ruleApplies(m)) {
            return SOURCE;
        }
        return NOT_SOURCE;
    }

    @Override
    protected String getAntiMatch() {
        return NOT_SOURCE;
    }

    @Override
    protected void initRules() throws MarkupException, BadRuleException {
        Rule r = new Rule();
        r.setRuleName("toString for exception class - rule");
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
        r.getMethodRule().getSignatureRule().setRuleValue("tostring");
        r.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r.getMethodRule().getClassRule().setRuleValue("exception");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("toString for error class - rule");
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
        r.getMethodRule().getSignatureRule().setRuleValue("tostring");
        r.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r.getMethodRule().getClassRule().setRuleValue("error");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("getValue xml class - rule");
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
        r.getMethodRule().getSignatureRule().setRuleValue("getValue");
        BaseLogicGate g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        Rule r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("xml");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("xml");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("html");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("html");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("getValue xml package - rule");
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
        r.getMethodRule().getSignatureRule().setRuleValue("getValue");
        r.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r.getMethodRule().getPackageRule().setRuleValue("xml");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("zip next - rule");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("next");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("stream");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("entr");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("getBytes");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("inflate");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("deflate");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("zip");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("jar");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("read - more than 0 args - rule");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("read");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_START_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("readable");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_END_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("resolve");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getSignatureRule().setRuleValue("length");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getSignatureRule().setRuleValue("meta");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getClassRule().setRuleValue("ClassFile");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getClassRule().setRuleValue("heap");
        r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_GREATER_THAN);
        r.getMethodRule().getArgCountRule().setArgCountValue(0);
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("getParameter - more than 0 args - rule");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("getParameter");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getSignatureRule().setRuleValue("type");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getSignatureRule().setRuleValue("name");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getSignatureRule().setRuleValue("meta");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("read - 0 args - rule");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("read");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_START_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("readable");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_END_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("resolve");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getSignatureRule().setRuleValue("length");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getSignatureRule().setRuleValue("spec");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getClassRule().setRuleValue("heap");
        r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
        r.getMethodRule().getArgCountRule().setArgCountValue(0);
        this.addNotNullReturn(r);
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("http type items - rule");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("httprequest");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("httpresponse");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("httpentity");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("get");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("put");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("post");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("body");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("iterator");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("element");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("toString");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("data");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("asString");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("flatmap");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("apply");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("get with spray - rule");
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r.getMethodRule().getSignatureRule().setRuleValue("get");
        r.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r.getMethodRule().getPackageRule().setRuleValue("spray");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("post with spray - rule");
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r.getMethodRule().getSignatureRule().setRuleValue("post");
        r.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r.getMethodRule().getPackageRule().setRuleValue("spray");
        this.getRules().add(r);
    }

    @Override
    protected void initAntiRules() throws MarkupException, BadRuleException {
        Rule r = new Rule();
        r.setRuleName("Setter - anti rule");
        r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_SETTER);
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("Static setter - anti rule");
        r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_STATIC);
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r.getMethodRule().getSignatureRule().setRuleValue("set");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("pipelining$ get - anti rule");
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r.getMethodRule().getSignatureRule().setRuleValue("get");
        r.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r.getMethodRule().getClassRule().setRuleValue("pipelining$");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("Boolean return - anti rule");
        r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r.getMethodRule().getReturnRule().setRuleValue("boolean");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("Constructor - anti rule");
        r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_CONSTRUCTOR);
        this.getAntiRules().add(r);
        r = new Rule();
        r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r.getMethodRule().getReturnRule().setRuleValue("java.lang.Class");
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r.getMethodRule().getSignatureRule().setRuleValue("getCategory");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("Number class - anti rule");
        BaseLogicGate g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        Rule r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("double");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("long");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("integer");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("queue");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("Getter - boolean/void/number return - anti rule");
        r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_GETTER);
        r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
        r.getMethodRule().getArgCountRule().setArgCountValue(0);
        this.addNullReturn(r);
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("access - boolean/void/number return - anti rule");
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r.getMethodRule().getSignatureRule().setRuleValue("access");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("Class contains");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("ConcurrentLinkedDeque");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("CharsetEncoder");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("MethodType");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("MethodHandle");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("MethodType");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("Color");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("Container");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("Desktop");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("frame");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("class");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("label");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("keyboard");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("ClassFile");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("Class contains");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("get");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("List");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("Time or date class - anti");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("date");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("time");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("locale");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("duration");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("calendar");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("duration");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("time");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("date");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("locale");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("calendar");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("Decimal class - anti");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("decimal");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("currency");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("decimal");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("currency");
        this.getAntiRules().add(r);
        r = new Rule();
        r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_GETTER);
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
        r.getMethodRule().getSignatureRule().setRuleValue("type");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("to - non excpetion,error API - anti");
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r.getMethodRule().getSignatureRule().setRuleValue("to");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getClassRule().setRuleValue("exception");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getClassRule().setRuleValue("error");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("get...point - anti");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r1.getMethodRule().getClassRule().setRuleValue("get");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
        r1.getMethodRule().getClassRule().setRuleValue("point");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("get...index - anti");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r1.getMethodRule().getClassRule().setRuleValue("get");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
        r1.getMethodRule().getClassRule().setRuleValue("index");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("0 args - boolean/void/number return");
        r.getMethodRule().getArgCountRule().setArgCountValue(0);
        r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
        this.addNullReturn(r);
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("1 number arg - boolean/void/number return - anti rule");
        r.getMethodRule().getArgCountRule().setArgCountValue(1);
        r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
        r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r.getMethodRule().getArgumentRule().setRuleValue("number");
        this.addNullReturn(r);
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("get...Id - anti rule");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("id");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("get");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getSignatureRule().setRuleValue("user");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r.getMethodRule().getSignatureRule().setRuleValue("pass");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getSignatureRule().setRuleValue("session");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("number args and return - anti");
        r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r.getMethodRule().getArgumentRule().setRuleValue("number");
        this.addNullReturn(r);
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("mock - anti");
        r.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r.getMethodRule().getClassRule().setRuleValue("Mock");
        this.getAntiRules().add(r);
    }

    private void addNullReturn(Rule r) throws BadRuleException {
        BaseLogicGate g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        Rule r1 = g.createRule();
        r1.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getReturnRule().setRuleValue("boolean");
        r1 = g.createRule();
        r1.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getReturnRule().setRuleValue("void");
        r1 = g.createRule();
        r1.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getReturnRule().setRuleValue("number");
    }

    private void addNotNullReturn(Rule r) throws BadRuleException {
        BaseLogicGate g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        Rule r1 = g.createRule();
        r1.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL);
        r1.getMethodRule().getReturnRule().setRuleValue("boolean");
        r1 = g.createRule();
        r1.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL);
        r1.getMethodRule().getReturnRule().setRuleValue("void");
        r1 = g.createRule();
        r1.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL);
        r1.getMethodRule().getReturnRule().setRuleValue("number");
    }

    @Override
    public String getDefaultValue() {
        return NOT_SOURCE;
    }
}

