/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.model;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.ica.markup.MarkupException;
import com.ibm.appscan.ica.model.AbstractRemoteIcaModel;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.markup.Taint;
import com.ibm.appscan.vdb.provider.VdbProvider;

public class IcaTaintModel
extends AbstractRemoteIcaModel {
    IcaTaintModel() {
        this.m_batchSize = 8;
        this.m_parallelRequests = 4;
        this.m_serviceName = "ica-main-service";
        this.m_path = "/v2/models/ica-taint";
    }

    private boolean isDotNetInvoke(Method method) {
        return method.getLang() == Language.LANGUAGE.DOT_NET && method.getSignature().contains(".Invoke(");
    }

    static Taint getTaintTriple(Method m) throws VDBException {
        if (m.getArgs().size() == 0) {
            if (IcaTaintModel.isTaintType(m.getReturn(), m.getLang())) {
                if (m.isStatic()) {
                    return new Taint("none", "none", false);
                }
                return new Taint("this", "none", true);
            }
            return new Taint("none", "none", false);
        }
        if (IcaTaintModel.isTaintType(m.getReturn(), m.getLang())) {
            if (m.isStatic()) {
                if (VdbProvider.isTaintPossibleArgs((Method)m)) {
                    return new Taint("default", "none", true);
                }
                return new Taint("none", "none", false);
            }
            if (VdbProvider.isTaintPossibleArgs((Method)m)) {
                return new Taint("all", "all", true);
            }
            return new Taint("this", "none", true);
        }
        if (m.isStatic()) {
            return new Taint("default", "default", false);
        }
        if (m.getSignature().contains("TryGet")) {
            return new Taint("this", Integer.toString(m.getArgs().size()), false);
        }
        if (VdbProvider.isTaintPossibleArgs((Method)m)) {
            return new Taint("default", "this", false);
        }
        return new Taint("none", "none", false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void applyMarkup(Method method, String prediction) throws MarkupException {
        if (this.isDotNetInvoke(method)) {
            try {
                method.addTaint("all", "all", true);
                return;
            }
            catch (VDBException e) {
                throw new MarkupException(e);
            }
        }
        if ("True".equals(prediction)) {
            try {
                Taint taintTriple = IcaTaintModel.getTaintTriple(method);
                if (taintTriple.isNotSusceptibleToTaint()) return;
                method.addTaint(taintTriple);
                return;
            }
            catch (VDBException e) {
                throw new MarkupException(e);
            }
        }
        try {
            method.setNotSusceptibleToTaint();
            return;
        }
        catch (BadMarkupException badMarkupException) {
            // empty catch block
        }
    }
}

