/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.weblogic.compilers;

import com.ibm.appscan.common.xml.XMLFileReader;
import com.ibm.appscan.common.xml.XMLStreamReader;
import com.ibm.appscan.discovery.weblogic.IVersionConstants;
import java.io.File;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class ServerInfo
extends XMLFileReader {
    private static final String PRODUCT_MARKER = "registry.xml";
    private static final String E_VERSION = "version";
    private static String m_version = null;

    static ServerInfo readServerInfo(File serverHome) {
        File prodMarker10 = new File(serverHome, PRODUCT_MARKER);
        File prodMarker12 = new File(serverHome, "inventory" + File.separator + PRODUCT_MARKER);
        if (prodMarker10.isFile()) {
            ServerInfo server = new ServerInfo(prodMarker10);
            m_version = "10";
            return server;
        }
        if (prodMarker12.isFile()) {
            ServerInfo server = new ServerInfo(prodMarker12);
            m_version = "12";
            return server;
        }
        return null;
    }

    private ServerInfo(File productMarker) {
        super(productMarker);
    }

    private void checkVersion(String version) {
        for (String supportedVersion : IVersionConstants.VERSIONS) {
            if (!(version + ".").startsWith(supportedVersion + ".")) continue;
            m_version = supportedVersion;
            return;
        }
    }

    protected boolean process(StartElement element, XMLStreamReader.ElementValue value) throws XMLStreamException {
        if (E_VERSION.equals(element.getName().getLocalPart())) {
            this.checkVersion(value.getText());
            return false;
        }
        return true;
    }

    String getVersion() {
        return m_version;
    }
}

