/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.spring3;

import com.ibm.appscan.frameworks.analyzers.spring.SpringConfigFileInfo;
import com.ibm.appscan.frameworks.handlers.spring3.Spring3BeanInfo;
import com.ibm.appscan.frameworks.handlers.spring3.SpringValidator;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.types.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SpringBeanAndValidatorManager {
    private Map<String, Spring3BeanInfo> beanMap = new HashMap<String, Spring3BeanInfo>();
    private Map<String, ArrayList<SpringValidator>> validatorMap = new HashMap<String, ArrayList<SpringValidator>>();

    public void addBean(Spring3BeanInfo bean) {
        if (bean.isConvertedFromSpring25BeanInfo()) {
            if (bean.getId() != null) {
                this.beanMap.put(bean.getId(), bean);
            }
            if (bean.getNames() != null) {
                for (String name : bean.getNames()) {
                    this.beanMap.put(name, bean);
                }
            }
        } else {
            this.beanMap.put(bean.getName(), bean);
        }
    }

    public void addSpring25BeanInfoList(Set<SpringConfigFileInfo.SpringBeanInfo> spring25BeanList) {
        for (SpringConfigFileInfo.SpringBeanInfo bean : spring25BeanList) {
            this.addBean(new Spring3BeanInfo(bean));
        }
    }

    public Spring3BeanInfo findBean(String beanNameOrId) {
        return this.beanMap.get(beanNameOrId);
    }

    public Map<String, Spring3BeanInfo> getBeans() {
        return this.beanMap;
    }

    public void addValidator(SpringValidator validator) {
        ArrayList<SpringValidator> validators4Clazz = this.validatorMap.get(validator.getClazzToBeValidate().getName().toString());
        if (validators4Clazz != null) {
            validators4Clazz.add(validator);
        } else {
            validators4Clazz = new ArrayList();
            validators4Clazz.add(validator);
            this.validatorMap.put(validator.getClazzToBeValidate().getName().toString(), validators4Clazz);
        }
    }

    public ArrayList<SpringValidator> getValidator(TypeReference classType) {
        return this.validatorMap.get(classType.getName().toString());
    }

    public ArrayList<SpringValidator> getValidator(IClass clazz) {
        return this.validatorMap.get(clazz.getName().toString());
    }
}

