/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.specinfo;

import com.ibm.appscan.frameworks.specinfo.ArgToOrigCallExpr;
import com.ibm.appscan.frameworks.specinfo.AssignmentExpr;
import com.ibm.appscan.frameworks.specinfo.BeanDecl;
import com.ibm.appscan.frameworks.specinfo.CallSiteReplacement;
import com.ibm.appscan.frameworks.specinfo.FormalParameterExpr;
import com.ibm.appscan.frameworks.specinfo.GlobalRefExpr;
import com.ibm.appscan.frameworks.specinfo.IFrameworkInfo;
import com.ibm.appscan.frameworks.specinfo.ISyntheticMethod;
import com.ibm.appscan.frameworks.specinfo.InvokeExpr;
import com.ibm.appscan.frameworks.specinfo.LocalRefExpr;
import com.ibm.appscan.frameworks.specinfo.NonDetSelectionExpr;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.ObjectRefExpr;
import com.ibm.appscan.frameworks.specinfo.Property;
import com.ibm.appscan.frameworks.specinfo.ReturnExpr;
import com.ibm.appscan.frameworks.specinfo.SyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.TaintExpr;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringEscapeUtils;

public class WAFLSpecSerializer {
    private static final String INDENT = "  ";
    private final boolean outputFilePosInfo;

    public static WAFLSpecSerializer make(boolean outputFilePosInfo) {
        return new WAFLSpecSerializer(outputFilePosInfo);
    }

    private WAFLSpecSerializer(boolean outputFilePosInfo) {
        this.outputFilePosInfo = outputFilePosInfo;
    }

    public String getFrameworkSpec(IFrameworkInfo info) {
        StringBuilder sb = new StringBuilder();
        sb.append("<wafl xmlns=\"http://www.ibm.com/WAFLSchema\">\n");
        this.appendGlobalBeanDeclarations(info.getGlobalBeanDeclarations(), 1, sb);
        this.appendSyntheticMethods(info.getSyntheticMethods(), 1, sb);
        this.appendEntrypointToURLMappings(info.getEntrypointSignatureToURLMappings(), 1, sb);
        this.appendCallReplacements(info.getMethodToReplacementsMapping(), 1, sb);
        sb.append("</wafl>\n");
        return sb.toString();
    }

    private void appendEntrypointToURLMappings(Map<String, Set<String>> map, int indentLevel, StringBuilder sb) {
        this.appendIndent(indentLevel, sb);
        sb.append("<entrypoints>\n");
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            this.appendEntrypoint(entry, indentLevel + 1, sb);
        }
        this.appendIndent(indentLevel, sb);
        sb.append("</entrypoints>\n");
    }

    private void appendEntrypoint(Map.Entry<String, Set<String>> entry, int indentLevel, StringBuilder sb) {
        this.appendIndent(indentLevel, sb);
        sb.append("<entrypoint sig=\"" + StringEscapeUtils.escapeXml((String)entry.getKey()) + "\">\n");
        for (String urlPattern : entry.getValue()) {
            this.appendIndent(indentLevel + 1, sb);
            try {
                String encodedURLPattern = URLEncoder.encode(urlPattern, "UTF-8");
                sb.append("<url>" + urlPattern + "</url>\n");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        this.appendIndent(indentLevel, sb);
        sb.append("</entrypoint>\n");
    }

    private void appendCallReplacements(Map<String, Set<CallSiteReplacement>> map, int indentLevel, StringBuilder sb) {
        this.appendIndent(indentLevel, sb);
        sb.append("<call-replacements>\n");
        for (String callerVDBSig : map.keySet()) {
            for (CallSiteReplacement replacement : map.get(callerVDBSig)) {
                this.appendCallSiteReplacement(callerVDBSig, replacement, indentLevel + 1, sb);
            }
        }
        this.appendIndent(indentLevel, sb);
        sb.append("</call-replacements>\n");
    }

    private void appendCallSiteReplacement(String callerVDBSig, CallSiteReplacement replacement, int indentLevel, StringBuilder sb) {
        this.appendIndent(indentLevel, sb);
        sb.append("<replace-call>\n");
        this.appendCallSiteInfo(callerVDBSig, replacement, indentLevel + 1, sb);
        this.appendCallSiteReplacementExpr(replacement.getStatement(), indentLevel + 1, sb);
        this.appendIndent(indentLevel, sb);
        sb.append("</replace-call>\n");
    }

    private void appendCallSiteReplacementExpr(SyntheticExpr expr, int indentLevel, StringBuilder sb) {
        this.appendIndent(indentLevel, sb);
        sb.append("<replacement>\n");
        this.appendStringForExpr(expr, sb, indentLevel + 1);
        this.appendIndent(indentLevel, sb);
        sb.append("</replacement>\n");
    }

    private void appendCallSiteInfo(String callerVDBSig, CallSiteReplacement replacement, int indentLevel, StringBuilder sb) {
        this.appendIndent(indentLevel, sb);
        sb.append("<call-site-info caller=\"" + callerVDBSig + "\" call-sig=\"" + replacement.getVdbMethodSig() + "\" bytecodeIndex=\"" + replacement.getBytecodeIndex() + "\"");
        this.appendFilePosAttributes(sb, replacement.getStatement());
        int srcLine = replacement.getSrcLine();
        if (srcLine != -1) {
            sb.append(" srcLineNum=\"" + srcLine + "\"");
        }
        sb.append("/>\n");
    }

    private void appendSyntheticMethods(Set<ISyntheticMethod> syntheticMethods, int indentLevel, StringBuilder sb) {
        this.appendIndent(indentLevel, sb);
        sb.append("<synthetic-methods>\n");
        TreeSet<ISyntheticMethod> validationSynMethods = new TreeSet<ISyntheticMethod>(new Comparator<ISyntheticMethod>(){

            @Override
            public int compare(ISyntheticMethod object1, ISyntheticMethod object2) {
                return object1.getSignature().compareTo(object2.getSignature());
            }
        });
        for (ISyntheticMethod sm : syntheticMethods) {
            if (sm.getSignature().startsWith("AppScan.Synthetic.Validator")) {
                validationSynMethods.add(sm);
                continue;
            }
            this.appendSynthMethod(sm, sb, indentLevel + 1);
        }
        for (ISyntheticMethod sm : validationSynMethods) {
            this.appendSynthMethod(sm, sb, indentLevel + 1);
        }
        this.appendIndent(indentLevel, sb);
        sb.append("</synthetic-methods>\n");
    }

    private void appendGlobalBeanDeclarations(Set<BeanDecl> globalBeanDeclarations, int indentLevel, StringBuilder sb) {
        this.appendIndent(indentLevel, sb);
        sb.append("<global-bean-decls>\n");
        this.appendBeanDecls(sb, indentLevel + 1, globalBeanDeclarations, true);
        this.appendIndent(indentLevel, sb);
        sb.append("</global-bean-decls>\n");
    }

    private void appendSynthMethod(ISyntheticMethod sm, StringBuilder sb, int indentLevel) {
        this.appendIndent(indentLevel, sb);
        sb.append("<synthetic-method sig=\"" + StringEscapeUtils.escapeXml((String)sm.getSignature()) + "\">\n");
        this.appendBeanDecls(sm, sb, indentLevel + 1);
        this.appendIndent(indentLevel + 1, sb);
        sb.append("<body>\n");
        for (SyntheticExpr statement : sm.getStatements()) {
            this.appendStringForExpr(statement, sb, indentLevel + 2);
        }
        this.appendIndent(indentLevel + 1, sb);
        sb.append("</body>\n");
        this.appendIndent(indentLevel, sb);
        sb.append("</synthetic-method>\n");
    }

    private void appendStringForExpr(SyntheticExpr expr, StringBuilder sb, int indentLevel) {
        if (expr instanceof AssignmentExpr) {
            this.appendStringForAssignExpr(sb, indentLevel, (AssignmentExpr)expr);
        } else if (expr instanceof ObjectRefExpr) {
            ObjectRefExpr objectRef = (ObjectRefExpr)expr;
            this.appendIndent(indentLevel, sb);
            sb.append("<object-ref ap=\"" + StringEscapeUtils.escapeXml((String)objectRef.getAccessPath()) + "\">\n");
            this.appendStringForExpr(objectRef.getRef(), sb, indentLevel + 1);
            this.appendIndent(indentLevel, sb);
            sb.append("</object-ref>\n");
        } else if (expr instanceof TaintExpr) {
            TaintExpr taint = (TaintExpr)expr;
            this.appendIndent(indentLevel, sb);
            TaintExpr.EntityType entityType = taint.getEntityType();
            sb.append("<taint type=\"" + StringEscapeUtils.escapeXml((String)entityType.toString().toLowerCase()) + "\"");
            if (entityType.equals((Object)TaintExpr.EntityType.PARAMETER)) {
                sb.append(" name=\"" + StringEscapeUtils.escapeXml((String)taint.getParameterName()) + "\"");
            }
            sb.append("/>\n");
        } else if (expr instanceof GlobalRefExpr) {
            GlobalRefExpr globalRef = (GlobalRefExpr)expr;
            this.appendIndent(indentLevel, sb);
            sb.append("<global id=\"" + StringEscapeUtils.escapeXml((String)globalRef.getId()) + "\"/>\n");
        } else if (expr instanceof LocalRefExpr) {
            LocalRefExpr localRef = (LocalRefExpr)expr;
            this.appendIndent(indentLevel, sb);
            sb.append("<local id=\"" + StringEscapeUtils.escapeXml((String)localRef.getId()) + "\"/>\n");
        } else if (expr instanceof InvokeExpr) {
            InvokeExpr invoke = (InvokeExpr)expr;
            this.appendStringForInvokeExpr(sb, indentLevel, invoke);
        } else if (expr instanceof ArgToOrigCallExpr) {
            this.appendIndent(indentLevel, sb);
            sb.append("<arg-to-orig-call pos=\"" + ((ArgToOrigCallExpr)expr).getPos() + "\"/>\n");
        } else if (expr instanceof FormalParameterExpr) {
            this.appendIndent(indentLevel, sb);
            sb.append("<formal pos=\"" + ((FormalParameterExpr)expr).getParameterPos() + "\"/>\n");
        } else if (expr instanceof NonDetSelectionExpr) {
            this.appendIndent(indentLevel, sb);
            sb.append("<non-det>\n");
            for (NonVoidSyntheticExpr nonVoidSyntheticExpr : ((NonDetSelectionExpr)expr).getExpressions()) {
                this.appendStringForExpr(nonVoidSyntheticExpr, sb, indentLevel + 1);
            }
            this.appendIndent(indentLevel, sb);
            sb.append("</non-det>\n");
        } else if (expr instanceof ReturnExpr) {
            this.appendIndent(indentLevel, sb);
            sb.append("<return>\n");
            this.appendStringForExpr(((ReturnExpr)expr).getReturnedExpr(), sb, indentLevel + 1);
            this.appendIndent(indentLevel, sb);
            sb.append("</return>\n");
        } else assert (false) : "need to handle " + expr.getClass();
    }

    private void appendStringForInvokeExpr(StringBuilder sb, int indentLevel, InvokeExpr invoke) {
        this.appendIndent(indentLevel, sb);
        sb.append("<call signature=\"" + invoke.getCalleeVDBSignature() + "\"");
        this.appendFilePosAttributes(sb, invoke);
        sb.append(">\n");
        Map<Integer, NonVoidSyntheticExpr> actualParameterPos2Value = invoke.getActualParameterPos2Value();
        for (int pos : actualParameterPos2Value.keySet()) {
            this.appendIndent(indentLevel + 1, sb);
            sb.append("<actual-parameter pos=\"" + pos + "\">\n");
            this.appendStringForExpr(actualParameterPos2Value.get(pos), sb, indentLevel + 2);
            this.appendIndent(indentLevel + 1, sb);
            sb.append("</actual-parameter>\n");
        }
        this.appendIndent(indentLevel, sb);
        sb.append("</call>\n");
    }

    private void appendStringForAssignExpr(StringBuilder sb, int indentLevel, AssignmentExpr assignExpr) {
        this.appendIndent(indentLevel, sb);
        sb.append("<assignment");
        this.appendFilePosAttributes(sb, assignExpr);
        sb.append(">\n");
        this.appendIndent(indentLevel + 1, sb);
        sb.append("<l-value>\n");
        this.appendStringForExpr(assignExpr.getLval(), sb, indentLevel + 2);
        this.appendIndent(indentLevel + 1, sb);
        sb.append("</l-value>\n");
        this.appendIndent(indentLevel + 1, sb);
        sb.append("<r-value>\n");
        this.appendStringForExpr(assignExpr.getRval(), sb, indentLevel + 2);
        this.appendIndent(indentLevel + 1, sb);
        sb.append("</r-value>\n");
        this.appendIndent(indentLevel, sb);
        sb.append("</assignment>\n");
    }

    private void appendFilePosAttributes(StringBuilder sb, SyntheticExpr expr) {
        FilePositionInfo filePositionInfo = expr.getFilePositionInfo();
        if (filePositionInfo != null && this.outputFilePosInfo) {
            sb.append(" filename=\"" + StringEscapeUtils.escapeXml((String)filePositionInfo.getFilename()) + "\" lineNumber=\"" + filePositionInfo.getLineNumber() + "\" columnNumber=\"" + filePositionInfo.getColumnNumber() + "\"");
        }
    }

    private void appendIndent(int indentLevel, StringBuilder sb) {
        for (int i = 0; i < indentLevel; ++i) {
            sb.append(INDENT);
        }
    }

    private void appendBeanDecls(ISyntheticMethod sm, StringBuilder sb, int indentLevel) {
        Collection<BeanDecl> localBeanDeclarations = sm.getLocalBeanDeclarations();
        this.appendBeanDecls(sb, indentLevel, localBeanDeclarations, false);
    }

    private void appendBeanDecls(StringBuilder sb, int indentLevel, Collection<BeanDecl> beanDeclarations, boolean isGlobal) {
        for (BeanDecl beanDecl : beanDeclarations) {
            this.appendIndent(indentLevel, sb);
            if (isGlobal) {
                sb.append("<object-decl id=\"" + StringEscapeUtils.escapeXml((String)beanDecl.getId()) + "\"");
            } else {
                sb.append("<local-decl id=\"" + StringEscapeUtils.escapeXml((String)beanDecl.getId()) + "\"");
            }
            String type = beanDecl.getType();
            if (type != null) {
                sb.append(" type=\"" + StringEscapeUtils.escapeXml((String)type) + "\"");
            }
            if (isGlobal) {
                sb.append(" lifespan=\"" + StringEscapeUtils.escapeXml((String)beanDecl.getLifespan().toString().toLowerCase()) + "\"");
            }
            sb.append(">\n");
            for (Property property : beanDecl.getProperties()) {
                this.appendIndent(indentLevel + 1, sb);
                sb.append("<property id=\"" + StringEscapeUtils.escapeXml((String)property.getName()) + "\"");
                sb.append(" type=\"" + StringEscapeUtils.escapeXml((String)property.getType()) + "\"");
                sb.append("/>\n");
            }
            this.appendIndent(indentLevel, sb);
            if (isGlobal) {
                sb.append("</object-decl>\n");
                continue;
            }
            sb.append("</local-decl>\n");
        }
    }
}

