/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.ifa.common;

import com.hcl.appscan.ifa.common.IIfaLog;
import com.ibm.appscan.assessment.model.Assessment;
import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.common.logging.Message;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Optional;

public class IfaAssessment {
    private IIfaLog m_log;
    private Optional<Assessment> m_assessment;
    private Optional<HashSet<Finding>> m_set;

    public IfaAssessment(Assessment a, IIfaLog t) {
        this.m_log = t;
        Assessment new_assessment = new Assessment();
        new_assessment.copyAssessmentDetails(a);
        this.m_assessment = Optional.of(new_assessment);
        HashSet new_set = new HashSet(a.getFindingMap().size());
        new_set.addAll(a.getFindingList());
        new_set.addAll(a.getExcludedFindings());
        this.m_set = Optional.of(new_set);
    }

    public Assessment unwrap() {
        if (!this.m_set.get().isEmpty()) {
            throw new NoSuchElementException("Cannot unwrap " + this.getClass().getName() + " with findings remaining");
        }
        this.m_set = Optional.empty();
        Assessment a = this.m_assessment.get();
        this.m_assessment = Optional.empty();
        return a;
    }

    HashSet<Finding> getFindings() {
        return this.m_set.get();
    }

    void include(Finding f) {
        if (!this.m_set.get().remove(f)) {
            throw new NoSuchElementException("Can't include finding not present in unhandled set");
        }
        this.m_assessment.get().addFinding(f);
        this.m_log.logInclude(f);
    }

    void exclude(Finding f) {
        if (!this.m_set.get().remove(f)) {
            throw new NoSuchElementException("Can't exclude finding not present in unhandled set");
        }
        this.m_assessment.get().addExcludedFinding(f);
        this.m_log.logExclude(f);
    }

    void newRow(String ifaName, int nFindings) {
        this.m_log.newRow(ifaName, nFindings);
    }

    int size() {
        return this.m_set.get().size();
    }

    void logException(Exception e) {
        this.m_log.logException(e);
    }

    void addMessage(Message m) {
        this.m_log.addMessage(m);
    }
}

