/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.ifa.common;

import com.hcl.appscan.ifa.common.IfaAssessment;
import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.common.logging.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class IfaTarget
implements Iterable<Finding> {
    private IfaAssessment m_assessment;
    private Optional<HashSet<Finding>> m_slice;
    private Optional<IfaTarget> m_parent;

    IfaTarget(IfaAssessment a) {
        this.m_assessment = a;
        this.m_slice = Optional.empty();
        this.m_parent = Optional.empty();
    }

    private IfaTarget(IfaTarget p, Stream<Finding> fStream) {
        this.m_assessment = p.m_assessment;
        HashSet new_set = new HashSet();
        fStream.forEach(f -> new_set.add(f));
        this.m_slice = Optional.of(new_set);
        this.m_parent = Optional.of(p);
    }

    public IfaTarget slice(Predicate<Finding> p) {
        return new IfaTarget(this, this.getSlice().stream().filter(p));
    }

    public void includeFinding(Finding f) {
        this.m_assessment.include(f);
        this.recursiveRemove(f);
    }

    public void excludeFinding(Finding f) {
        this.m_assessment.exclude(f);
        this.recursiveRemove(f);
    }

    private void recursiveRemove(Finding f) {
        this.m_parent.ifPresent(p -> p.recursiveRemove(f));
        this.m_slice.ifPresent(s -> s.remove(f));
    }

    private HashSet<Finding> getSlice() {
        return this.m_slice.orElse(this.m_assessment.getFindings());
    }

    @Override
    public Iterator<Finding> iterator() {
        return Collections.unmodifiableCollection(new ArrayList<Finding>(this.getSlice())).iterator();
    }

    @Override
    public Spliterator<Finding> spliterator() {
        return Collections.unmodifiableCollection(new ArrayList<Finding>(this.getSlice())).spliterator();
    }

    public int size() {
        if (this.m_slice.isPresent()) {
            return this.m_slice.get().size();
        }
        return this.m_assessment.size();
    }

    public void logException(Exception e) {
        this.m_assessment.logException(e);
    }

    public void addMessage(Message m) {
        this.m_assessment.addMessage(m);
    }
}

