/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.source.scanner;

import com.hcl.appscan.source.scanner.ActionRunner;
import com.hcl.appscan.source.scanner.IAction;
import com.hcl.appscan.source.scanner.Messages;
import com.hcl.appscan.source.scanner.job.ScanJob;
import com.hcl.appscan.source.scanner.job.SubmitAction;
import com.hcl.appscan.source.scanner.logging.NullSourceCodeScannerProgress;
import com.hcl.appscan.source.scanner.logging.SourceCodeScannerException;
import com.hcl.appscan.source.scanner.logging.SourceCodeScannerProgress;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.File;

public class BetaSourceCodeScanner
implements IAction {
    private ScanJob m_job;
    private SourceCodeScannerProgress m_progress;

    public BetaSourceCodeScanner(String language, File zipFile, File logDir, IProgress progress) {
        String asocScanId = System.getProperty("APPSCAN_AGENT_JOBID");
        String scanURL = System.getProperty("cloudEngineBetaUrl");
        this.m_progress = SystemUtil.isDebug() ? new SourceCodeScannerProgress(progress, logDir) : new NullSourceCodeScannerProgress(logDir);
        this.m_job = new ScanJob(zipFile, asocScanId, language, this.m_progress, scanURL);
    }

    public void execute() throws SourceCodeScannerException {
        ActionRunner.executeAction(this, this.m_progress, 1);
    }

    @Override
    public void run() throws SourceCodeScannerException {
        this.executeJob();
    }

    private void executeJob() throws SourceCodeScannerException {
        ActionRunner.executeAction(new SubmitAction(this.m_job, this.m_progress), this.m_progress, 1);
    }

    @Override
    public String getDescription() {
        return Messages.getMessage("action.beta.submission", new Object[0]);
    }
}

