/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.source.scanner.results;

import com.hcl.appscan.source.scanner.IAction;
import com.hcl.appscan.source.scanner.Messages;
import com.hcl.appscan.source.scanner.logging.SourceCodeScannerException;
import com.ibm.appscan.assessment.AssessmentException;
import com.ibm.appscan.assessment.model.Assessment;
import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.assessment.model.Severity;
import com.ibm.appscan.assessment.model.Site;
import com.ibm.appscan.assessment.model.Taint;
import com.ibm.appscan.assessment.model.Trace;
import com.ibm.appscan.assessment.model.finding.FindingProvider;
import com.ibm.appscan.custom.scanner.finding.CustomScanEnum;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class ConvertResultsAction
implements IAction {
    private JSONObject m_rawResult;
    private File m_destination;
    private String m_jobId;
    private Map<String, String> m_sourceFileMap;
    private String m_language;

    public ConvertResultsAction(JSONObject rawResult, File destination, String jobId, Map<String, String> sourceFileMap, String language) {
        this.m_rawResult = rawResult;
        this.m_destination = destination;
        this.m_jobId = jobId;
        this.m_sourceFileMap = sourceFileMap;
        this.m_language = language;
    }

    @Override
    public void run() throws SourceCodeScannerException {
        try {
            Assessment assessment = new Assessment();
            JSONArray filesFindingsJson = this.m_rawResult.getJSONArray("FilesFindings");
            for (int fileIndex = 0; fileIndex < filesFindingsJson.length(); ++fileIndex) {
                JSONObject fileJson = filesFindingsJson.getJSONObject(fileIndex);
                String path = this.getMappedFile(fileJson.getString("FileName"));
                int linesOfCode = 0;
                if (fileIndex == 0 && this.m_rawResult.containsKey((Object)"LinesOfCode")) {
                    linesOfCode = this.m_rawResult.getInt("LinesOfCode");
                }
                assessment.addFileToMap(path, linesOfCode, this.m_language);
                JSONArray findingsJson = fileJson.getJSONArray("FileFindings");
                for (int findingIndex = 0; findingIndex < findingsJson.length(); ++findingIndex) {
                    JSONObject findingJson = findingsJson.getJSONObject(findingIndex);
                    assessment.addFindings(this.processFinding(findingJson));
                }
            }
            File asmt = new File(this.m_destination, this.m_jobId + ".xml");
            assessment.save(asmt);
        }
        catch (AssessmentException | JSONException e) {
            throw new SourceCodeScannerException(e);
        }
    }

    @Override
    public String getDescription() {
        return Messages.getMessage("action.convert.result", new Object[0]);
    }

    private String getMappedFile(String path) {
        String pathSep = System.getProperty("file.separator");
        if (pathSep.equals("\\")) {
            pathSep = "\\\\";
        }
        return (this.m_sourceFileMap.containsKey(path) ? this.m_sourceFileMap.get(path) : path).replaceAll("[/\\\\]+", pathSep);
    }

    private Severity translateSeverity(String s) {
        switch (Integer.parseInt(s)) {
            case 0: {
                return Severity.High;
            }
            case 1: {
                return Severity.Medium;
            }
            case 2: {
                return Severity.Low;
            }
            case 3: {
                return Severity.Informational;
            }
            case 4: {
                return Severity.None;
            }
            case 5: {
                return Severity.Critical;
            }
        }
        return Severity.None;
    }

    private String clean(String s) {
        char[] c = s.toCharArray();
        for (int i = 0; i < s.length(); ++i) {
            if (c[i] >= ' ' && c[i] <= '\ud7ff' || c[i] >= '\ue000' && c[i] <= '\ufffd' || c[i] >= '\u10000' && c[i] <= '\u10ffff' || c[i] == '\t' || c[i] == '\n' || c[i] == '\r') continue;
            c[i] = 32;
        }
        return new String(c);
    }

    private List<Finding> processFinding(JSONObject findingJson) throws JSONException {
        int line = Integer.parseInt((String)findingJson.getOrDefault((Object)CustomScanEnum.LINE_NUMBER_A, (Object)0));
        String file = this.clean(this.getMappedFile((String)findingJson.getOrDefault((Object)CustomScanEnum.FILE_NAME_A, (Object)"")));
        String column = this.clean((String)findingJson.getOrDefault((Object)CustomScanEnum.COLUMN_NUMBER_A, (Object)0));
        String context = this.clean((String)findingJson.getOrDefault((Object)CustomScanEnum.CONTEXT_A, (Object)""));
        String vulnName = this.clean((String)findingJson.getOrDefault((Object)CustomScanEnum.VULN_NAME_A, (Object)""));
        CustomScanEnum.CONFIDENCE confidence = CustomScanEnum.getConfidence((String)((String)findingJson.getOrDefault((Object)CustomScanEnum.CONFIDENCE_A, (Object)"")));
        Severity severity = this.translateSeverity((String)findingJson.getOrDefault((Object)CustomScanEnum.SEVERITY_A, (Object)""));
        String vulnType = this.clean((String)findingJson.getOrDefault((Object)CustomScanEnum.VULN_TYPE_A, (Object)""));
        String language = this.clean((String)findingJson.getOrDefault((Object)"language", (Object)this.m_language));
        String ruleId = this.clean((String)findingJson.getOrDefault((Object)"issue_type", (Object)""));
        ArrayList<Finding> findings = new ArrayList<Finding>(1);
        List<Trace> traces = this.getTrace(findingJson);
        for (Trace trace : traces) {
            findings.add(FindingProvider.getFinding((Trace)trace, (String)file, (Site)new Site(file, line, 0, file, "", context, vulnName, "", language, "", "", column), (String)"", (String)ruleId, (String)"", (String)confidence.toString(), (String)severity.toString(), (String)vulnType, (String)"H", (String)"", (String)"", null, null, null, null, null, null));
        }
        return findings;
    }

    private List<Trace> getTrace(JSONObject findingJson) throws JSONException {
        Object o = findingJson.getOrDefault((Object)"sites", null);
        ArrayList<Trace> traces = new ArrayList<Trace>();
        traces.add(null);
        if (Objects.isNull(o)) {
            return traces;
        }
        JSONArray sites = (JSONArray)o;
        if (sites.length() == 0) {
            return traces;
        }
        traces.clear();
        Trace trace = new Trace();
        int current_collection = -404;
        String mainContext = this.clean((String)findingJson.getOrDefault((Object)CustomScanEnum.CONTEXT_A, (Object)""));
        int mainline = Integer.parseInt((String)findingJson.getOrDefault((Object)CustomScanEnum.LINE_NUMBER_A, (Object)0));
        String vulnType = this.clean((String)findingJson.getOrDefault((Object)CustomScanEnum.VULN_TYPE_A, (Object)""));
        for (int i = 0; i < sites.length(); ++i) {
            int collection;
            int hlEnd;
            JSONObject site = sites.getJSONObject(i);
            int line = Integer.parseInt((String)site.getOrDefault((Object)"line", (Object)0));
            String context = this.clean((String)site.getOrDefault((Object)"snippet", (Object)""));
            String nodeType = this.clean((String)site.getOrDefault((Object)"type", (Object)""));
            int hlStart = (Integer)site.getOrDefault((Object)"highlight_start", (Object)0);
            if (hlStart < 0) {
                hlStart = 0;
            }
            if (hlStart > context.length()) {
                hlStart = context.length();
            }
            if ((hlEnd = ((Integer)site.getOrDefault((Object)"highlight_end", (Object)context.length())).intValue()) < 0) {
                hlEnd = 0;
            }
            if (hlEnd > context.length()) {
                hlEnd = context.length();
            }
            if (hlEnd < hlStart) {
                hlEnd = hlStart;
            }
            if ((collection = ((Integer)site.getOrDefault((Object)"site_collection", (Object)-1)).intValue()) != current_collection) {
                if (trace.getTaintList().size() > 0) {
                    if (collection >= 0) {
                        ((Taint)trace.getTaintList().getLast()).setTrace_type("Sink");
                    } else {
                        trace.addTaintItem(this.getTaint(findingJson, mainline, mainContext, vulnType, "Sink", 0, 0), ".");
                    }
                    traces.add(trace);
                }
                trace = new Trace();
                trace.addTaintItem(this.getTaint(findingJson, 0, "", nodeType, "None", 0, 0), "");
                trace.addTaintItem(this.getTaint(findingJson, line, context, nodeType, "Source", hlStart, hlEnd), ".");
                current_collection = collection;
                continue;
            }
            trace.addTaintItem(this.getTaint(findingJson, line, context, nodeType, "TaintProp", hlStart, hlEnd), ".");
        }
        if (current_collection >= 0) {
            ((Taint)trace.getTaintList().getLast()).setTrace_type("Sink");
        } else {
            trace.addTaintItem(this.getTaint(findingJson, mainline, mainContext, vulnType, "Sink", 0, 0), ".");
        }
        traces.add(trace);
        return traces;
    }

    private Taint getTaint(JSONObject findingJson, int line, String context, String nodeType, String taintType, int highlightStart, int highlightEnd) {
        String file = this.clean(this.getMappedFile((String)findingJson.getOrDefault((Object)CustomScanEnum.FILE_NAME_A, (Object)"")));
        String language = this.clean((String)findingJson.getOrDefault((Object)"language", (Object)this.m_language));
        return new Taint(new Site(file, line, 0, "", file, context, context, context, language, "", "", "0"), 1, context.substring(highlightStart, highlightEnd), "None", taintType);
    }
}

