/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.set;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.set.RubySet;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"SortedSet"}, parent="Set")
public class RubySortedSet
extends RubySet
implements SortedSet {
    private final TreeSet<IRubyObject> order;

    static RubyClass createSortedSetClass(Ruby runtime2) {
        RubyClass SortedSet2 = runtime2.defineClass("SortedSet", runtime2.getClass("Set"), RubySortedSet::new);
        SortedSet2.setReifiedClass(RubySortedSet.class);
        SortedSet2.defineAnnotatedMethods(RubySortedSet.class);
        return SortedSet2;
    }

    protected RubySortedSet(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
        this.order = new TreeSet<IRubyObject>(new OrderComparator(runtime2));
    }

    @Override
    void unmarshal() {
        super.unmarshal();
        IRubyObject[] elems = this.hash.keys().toJavaArrayMaybeUnsafe();
        for (int i2 = 0; i2 < elems.length; ++i2) {
            this.order.add(elems[i2]);
        }
    }

    @JRubyMethod(name={"[]"}, rest=true, meta=true)
    public static RubySortedSet create(ThreadContext context, IRubyObject self2, IRubyObject ... ary) {
        Ruby runtime2 = context.runtime;
        RubySortedSet set2 = new RubySortedSet(runtime2, (RubyClass)self2);
        return (RubySortedSet)set2.initSet(context, ary, 0, ary.length);
    }

    @Override
    protected void addImpl(Ruby runtime2, IRubyObject obj) {
        super.addImpl(runtime2, obj);
        this.order.add(obj);
    }

    @Override
    protected void addImplSet(ThreadContext context, RubySet set2) {
        super.addImplSet(context, set2);
        this.order.addAll(set2.elements());
    }

    @Override
    protected boolean deleteImpl(IRubyObject obj) {
        if (super.deleteImpl(obj)) {
            this.order.remove(obj);
            return true;
        }
        return false;
    }

    @Override
    protected void deleteImplIterator(IRubyObject obj, Iterator it) {
        super.deleteImpl(obj);
        it.remove();
    }

    @Override
    protected void clearImpl() {
        this.hash.rb_clear(this.getRuntime().getCurrentContext());
        this.order.clear();
    }

    @JRubyMethod(name={"sort"})
    public RubyArray sort(ThreadContext context) {
        return RubyArray.newArray(context.runtime, this.order);
    }

    @Override
    public RubyArray to_a(ThreadContext context) {
        return this.sort(context);
    }

    @Override
    public IRubyObject initialize_dup(ThreadContext context, IRubyObject orig) {
        super.initialize_dup(context, orig);
        if (this != orig) {
            this.order.addAll(((RubySortedSet)orig).order);
        }
        return this;
    }

    @Override
    @JRubyMethod(frame=true, keywords=true, required=1, optional=1)
    public IRubyObject initialize_clone(ThreadContext context, IRubyObject[] args2) {
        super.initialize_clone(context, args2);
        IRubyObject orig = args2[0];
        if (this != orig) {
            this.order.addAll(((RubySortedSet)orig).order);
        }
        return this;
    }

    @Override
    protected Set<IRubyObject> elementsOrdered() {
        return this.order;
    }

    @Override
    public Iterator<Object> iterator() {
        return new JavaIterator();
    }

    public Comparator<? super IRubyObject> comparator() {
        return this.order.comparator();
    }

    public Object first() {
        return this.firstValue().toJava(Object.class);
    }

    public IRubyObject firstValue() {
        return this.order.first();
    }

    public Object last() {
        return this.lastValue().toJava(Object.class);
    }

    public IRubyObject lastValue() {
        return this.order.last();
    }

    public SortedSet headSet(Object toElement) {
        throw new UnsupportedOperationException("NOT IMPLEMENTED");
    }

    public SortedSet subSet(Object fromElement, Object toElement) {
        throw new UnsupportedOperationException("NOT IMPLEMENTED");
    }

    public SortedSet tailSet(Object fromElement) {
        throw new UnsupportedOperationException("NOT IMPLEMENTED");
    }

    public SortedSet<IRubyObject> rawHeadSet(IRubyObject toElement) {
        return this.order.headSet(toElement);
    }

    public SortedSet<IRubyObject> rawSubSet(IRubyObject fromElement, IRubyObject toElement) {
        return this.order.subSet(fromElement, toElement);
    }

    public SortedSet<IRubyObject> rawTailSet(IRubyObject fromElement) {
        return this.order.tailSet(fromElement);
    }

    private class JavaIterator
    implements Iterator<Object> {
        private final Iterator<IRubyObject> rawIterator;

        JavaIterator() {
            this.rawIterator = RubySortedSet.this.order.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.rawIterator.hasNext();
        }

        @Override
        public Object next() {
            return this.rawIterator.next().toJava(Object.class);
        }

        @Override
        public void remove() {
            this.rawIterator.remove();
        }
    }

    private static class OrderComparator
    extends RubyArray.DefaultComparator {
        private final Ruby runtime;

        OrderComparator(Ruby runtime2) {
            super(null);
            this.runtime = runtime2;
        }

        @Override
        protected ThreadContext context() {
            return this.runtime.getCurrentContext();
        }

        @Override
        public int compare(IRubyObject obj1, IRubyObject obj2) {
            int cmp2 = super.compare(obj1, obj2);
            if (cmp2 == 0) {
                return RubyObject.equalInternal(this.context(), obj1, obj2) ? 0 : 1;
            }
            return cmp2;
        }
    }
}

