/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ReverseIterator<T>
implements Iterator<T> {
    final ArrayList<T> list = new ArrayList();
    int nextIndex;

    private ReverseIterator(Iterator<T> other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException("other == null");
        }
        while (other.hasNext()) {
            this.list.add(other.next());
        }
        this.nextIndex = this.list.size() - 1;
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex > -1;
    }

    @Override
    public T next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.list.get(this.nextIndex--);
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static <T> Iterator<T> reverse(Iterator<T> it) {
        return new ReverseIterator<T>(it);
    }
}

