/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator;

import com.ibm.wala.stringAnalysis.translator.IConstraint;
import com.ibm.wala.stringAnalysis.translator.IInvocationSymbolComposer;
import com.ibm.wala.stringAnalysis.translator.ITranslator;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class TranslatorRepository<T>
implements ITranslatorRepository<T> {
    protected final ITranslator<T> DEFAULT_TRANSLATOR;
    protected final ITranslator<T> INTERSECTION_TRANSLATOR;
    protected final Map<String, ITranslator<T>> translatorMap = new HashMap<String, ITranslator<T>>();
    protected final ITranslatorRepository<T> prevRepository;
    private final Map<String, IInvocationSymbolComposer<T>> composers = new HashMap<String, IInvocationSymbolComposer<T>>();

    public TranslatorRepository(ITranslatorRepository<T> prevRepository) {
        this.prevRepository = prevRepository;
        this.DEFAULT_TRANSLATOR = this.createDefaultTranslator();
        this.INTERSECTION_TRANSLATOR = this.createIntersectionTranslator();
        this.put("&", this.INTERSECTION_TRANSLATOR);
    }

    public TranslatorRepository() {
        this(null);
    }

    @Override
    public void put(String signature, ITranslator<T> translator) {
        this.translatorMap.put(signature, translator);
    }

    protected void putComposer(String sig, IInvocationSymbolComposer<T> composer) {
        this.composers.put(sig, composer);
    }

    @Override
    public boolean isComposable(String sig) {
        return this.composers.containsKey(sig);
    }

    @Override
    public IInvocationSymbolComposer<T> getComposer(String sig) {
        return this.composers.get(sig);
    }

    @Override
    public boolean hasAllSignatures(Collection<String> signatures) {
        for (String signature : signatures) {
            if (this.hasSignature(signature)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasSignature(String signature) {
        if (this.translatorMap.containsKey(signature)) {
            return true;
        }
        if (this.prevRepository != null) {
            return this.prevRepository.hasSignature(signature);
        }
        return false;
    }

    @Override
    public ITranslator<T> getTranslator(String signature) {
        if (this.translatorMap.containsKey(signature)) {
            return this.translatorMap.get(signature).copy();
        }
        if (this.prevRepository != null) {
            return this.prevRepository.getTranslator(signature);
        }
        return this.DEFAULT_TRANSLATOR.copy();
    }

    @Override
    public IConstraint<T> getConstraint(String signature) {
        ITranslator<T> t = this.getTranslator(signature);
        if (t instanceof IConstraint) {
            return (IConstraint)t;
        }
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)("not a constraint: " + signature));
        }
        return null;
    }
}

