/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.cfg.repository;

import com.ibm.wala.automaton.grammar.string.IllegalGrammarException;
import com.ibm.wala.automaton.regex.string.StringPatternSymbol;
import com.ibm.wala.automaton.string.Automaton;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.stringAnalysis.translator.TranslationException;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.Transducer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class Strreplace
extends Transducer {
    private int repStrIndex;
    private int searchStrIndex;
    private boolean regexSearch;

    public Strreplace(int target, int search, int replace, boolean regexSearch) {
        super(target);
        this.repStrIndex = replace;
        this.searchStrIndex = search;
        this.regexSearch = regexSearch;
    }

    public Strreplace(int search, int replace, boolean regexSearch) {
        this.repStrIndex = replace;
        this.searchStrIndex = search;
        this.regexSearch = regexSearch;
    }

    protected Collection<IAutomaton> solveSearchPatterns(int searchStrIndex) throws IllegalGrammarException {
        Collection<String> strs = this.solveStringConstantParameters(searchStrIndex);
        HashSet<IAutomaton> fsas = new HashSet<IAutomaton>();
        for (String searchStr : strs) {
            Automaton searchFsa;
            Object object = searchFsa = this.regexSearch ? new StringPatternSymbol(this.solver.getRegexParser().parse(searchStr), this.monitor).getCompiledPattern() : Automatons.createAutomaton((List)StringSymbol.toCharSymbols((String)searchStr));
            if (searchFsa == null) {
                throw new IllegalGrammarException("failed to parse " + searchStr);
            }
            fsas.add((IAutomaton)searchFsa);
        }
        return fsas;
    }

    protected Collection<ISymbol> solveReplacementString(int repStrIndex) {
        try {
            Collection<String> strs = this.solveStringConstantParameters(repStrIndex);
            HashSet<ISymbol> syms = new HashSet<ISymbol>();
            for (String s : strs) {
                syms.add((ISymbol)new StringSymbol(s));
            }
            return syms;
        }
        catch (IllegalGrammarException e) {
            return Collections.singleton(new RangeSymbol('\u0000', '\uffff'));
        }
    }

    @Override
    public IAutomaton createTransducer() throws TranslationException {
        try {
            Collection<IAutomaton> searchFsas = this.solveSearchPatterns(this.searchStrIndex);
            Collection<ISymbol> repStrs = this.solveReplacementString(this.repStrIndex);
            for (ISymbol repStr : repStrs) {
                StringSymbol ssym;
                String str;
                if (!(repStr instanceof StringSymbol) || !(str = (ssym = (StringSymbol)repStr).getName()).matches(".*\\$\\d.*")) continue;
                throw new TranslationException("cannot treat the replacement string: " + str);
            }
            IAutomaton tr = null;
            for (IAutomaton searchFsa : searchFsas) {
                for (ISymbol repStr : repStrs) {
                    if (tr == null) {
                        tr = Strreplace.createTransducerFor(searchFsa, repStr, (IVariableFactory<IVariable>)this.varFactory);
                        continue;
                    }
                    IAutomaton tr2 = Strreplace.createTransducerFor(searchFsa, repStr, (IVariableFactory<IVariable>)this.varFactory);
                    tr = Automatons.createUnion((IAutomaton)tr, (IAutomaton)tr2);
                }
            }
            return tr;
        }
        catch (IllegalGrammarException e) {
            throw new TranslationException("cannot handle the search key.");
        }
    }

    public static IAutomaton createTransducerFor(IAutomaton searchFSA, ISymbol repStr, IVariableFactory<IVariable> vf) {
        return com.ibm.wala.stringAnalysis.translator.regular.repository.Strreplace.createTransducerFor(searchFSA, repStr, vf);
    }
}

