/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.regular.repository;

import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.NumberSymbol;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.stringAnalysis.translator.regular.repository.Homomorphism;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class CharTranslator
extends Homomorphism {
    public CharTranslator(int n) {
        super(n);
    }

    public CharTranslator() {
    }

    @Override
    public Set<Homomorphism.Rule> getRuleSet() {
        Homomorphism.Rule r = new Homomorphism.Rule(){

            public boolean accept(ISymbol symbol, IMatchContext ctx) {
                return symbol instanceof CharSymbol || symbol instanceof RangeSymbol || symbol instanceof NumberSymbol;
            }

            public List<ISymbol> invoke(ISymbol symbol, List<ISymbol> outputs) {
                if (symbol instanceof CharSymbol) {
                    CharSymbol csym = (CharSymbol)symbol;
                    ISymbol s = CharTranslator.this.translate(csym.charValue());
                    return new ArrayList<ISymbol>(Collections.singleton(s));
                }
                if (symbol instanceof NumberSymbol) {
                    CharSymbol csym = new CharSymbol((char)((NumberSymbol)symbol).intValue());
                    ISymbol s = CharTranslator.this.translate(csym.charValue());
                    return new ArrayList<ISymbol>(Collections.singleton(s));
                }
                if (symbol instanceof RangeSymbol) {
                    return CharTranslator.this.translate((RangeSymbol)symbol);
                }
                throw new RuntimeException("can't convert the symbol into characters: " + symbol);
            }

            public Collection<ISymbol> getTerminals() {
                return CharTranslator.this.getTerminals(Collections.emptySet());
            }
        };
        HashSet<Homomorphism.Rule> rs = new HashSet<Homomorphism.Rule>();
        rs.add(r);
        return rs;
    }

    @Override
    protected abstract ISymbol translate(char var1);

    @Override
    protected abstract List<ISymbol> translate(RangeSymbol var1);
}

