/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.cli.config.containers;

import com.hcl.appscan.cli.config.containers.PrepareScaHandler;
import com.ibm.appscan.cli.common.components.Command;
import com.ibm.appscan.cli.config.Messages;
import com.ibm.appscan.cli.config.commands.PrepareCommand;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class PrepareScaCommand
extends PrepareCommand {
    private static final String CONFIG_FILE_OPT = "-c";

    public PrepareScaCommand() {
    }

    public PrepareScaCommand(String[] args) {
        super(args);
    }

    public void configure() {
        this.setNamespace(Messages.NAMESPACE_CONFIGURATION);
        this.setName("prepare_sca");
        this.setDescription(com.hcl.appscan.discovery.containers.Messages.PREPARE_SCA_COMMAND_DESCRIPTION);
        this.setOptions(this.buildOptions(), true);
        this.enableLogLevelOptions();
    }

    public Command createCommand(String[] args) {
        return new PrepareScaCommand(args);
    }

    public void execute() {
        CommandLine cmd = this.getCommandLine();
        if (cmd == null) {
            return;
        }
        if (cmd.hasOption("image") || cmd.hasOption("container")) {
            File appscanConfig = null;
            try {
                this.validateOptions(cmd);
                appscanConfig = this.getAppScanConfig(cmd.getOptionValue("image"), cmd.getOptionValue("container"));
            }
            catch (AppScanException e) {
                Message message = new Message(4, e.getMessage());
                CommonCore.getIOConsole().println(message);
                m_logManager.log(message);
                return;
            }
            List<String> args = Arrays.asList(this.m_args);
            if (args.contains(CONFIG_FILE_OPT)) {
                int index = args.indexOf(CONFIG_FILE_OPT) + 1;
                args.set(index, appscanConfig.getAbsolutePath());
            } else {
                int argsLength = args.size() + 2;
                String[] newArgs = new String[argsLength];
                System.arraycopy(this.m_args, 0, newArgs, 0, this.m_args.length);
                newArgs[argsLength - 2] = CONFIG_FILE_OPT;
                newArgs[argsLength - 1] = appscanConfig.getAbsolutePath();
                this.m_args = newArgs;
            }
        }
        System.setProperty("OPENSOURCE_ONLY", "true");
        super.execute();
    }

    protected Options buildOptions() {
        Options options = super.buildOptions();
        OptionGroup group = new OptionGroup();
        OptionBuilder.withArgName((String)com.hcl.appscan.discovery.containers.Messages.IMAGE_OPTION_ARGUMENT);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)com.hcl.appscan.discovery.containers.Messages.IMAGE_OPTION_DESCRIPTION);
        group.addOption(OptionBuilder.create((String)"image"));
        options.addOptionGroup(group);
        group = new OptionGroup();
        OptionBuilder.withArgName((String)com.hcl.appscan.discovery.containers.Messages.CONTAINER_OPTION_ARGUMENT);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)com.hcl.appscan.discovery.containers.Messages.CONTAINER_OPTION_DESCRIPTION);
        group.addOption(OptionBuilder.create((String)"container"));
        options.addOptionGroup(group);
        return options;
    }

    protected Options getVisibleOptions(Options options) {
        Options visibleOptions = new Options();
        for (Object obj : options.getOptions()) {
            Option opt = (Option)obj;
            if ("ne".equals(opt.getOpt()) || "f".equals(opt.getOpt()) || "c".equals(opt.getOpt()) || "t".equals(opt.getOpt()) || "oso".equals(opt.getOpt()) || "sco".equals(opt.getOpt()) || "sao".equals(opt.getOpt()) || "dr".equals(opt.getOpt()) || "s".equals(opt.getOpt()) || "jdk".equals(opt.getOpt()) || "ns".equals(opt.getOpt()) || "so".equals(opt.getOpt()) || "es".equals(opt.getOpt()) || "ds".equals(opt.getOpt())) continue;
            visibleOptions.addOption(opt);
        }
        return visibleOptions;
    }

    private void validateOptions(CommandLine cmd) throws AppScanException {
        if (cmd.hasOption("image") && cmd.hasOption("container")) {
            throw new AppScanException(com.hcl.appscan.discovery.containers.Messages.bind(com.hcl.appscan.discovery.containers.Messages.INCOMPATIBLE_OPTIONS, "image", "container"));
        }
    }

    private File getAppScanConfig(String image, String container) throws AppScanException {
        File appscanConfig = null;
        if (container != null) {
            appscanConfig = new PrepareScaHandler(container, true).configureForDockerSCA();
        } else if (image != null) {
            appscanConfig = new PrepareScaHandler(image, false).configureForDockerSCA();
        }
        if (appscanConfig == null) {
            throw new AppScanException(com.hcl.appscan.discovery.containers.Messages.SCA_FAILED);
        }
        return appscanConfig;
    }
}

