/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.discovery.containers.utils;

import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarFile;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public class TarUtils {
    public static boolean isTarArchive(String file) {
        return new File(file).isFile() && (file.endsWith(".tar") || file.endsWith(".tar.gz"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsFiles(File archive, List<String> files) throws IOException {
        HashMap<String, Boolean> fileMap = new HashMap<String, Boolean>();
        for (String file : files) {
            fileMap.put(file, false);
        }
        TarArchiveInputStream tar = TarUtils.getTarArchiveInputStream(archive);
        TarArchiveEntry entry = null;
        try {
            while ((entry = tar.getNextTarEntry()) != null) {
                String path = entry.getName();
                if (!fileMap.containsKey(path)) continue;
                fileMap.put(path, true);
            }
        }
        finally {
            IOUtil.close((Closeable)tar);
        }
        return !fileMap.containsValue(false);
    }

    public static boolean containsFile(File archive, String file) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        files.add(file);
        return TarUtils.containsFiles(archive, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getFileFromArchive(File archive, File dest, String fileName) throws IOException {
        TarArchiveInputStream tar = TarUtils.getTarArchiveInputStream(archive);
        TarArchiveEntry entry = null;
        try {
            while ((entry = tar.getNextTarEntry()) != null) {
                String path = entry.getName();
                if (!path.equalsIgnoreCase(fileName)) continue;
                File newFile = new File(dest, path);
                if (newFile.isFile()) {
                    newFile.delete();
                }
                newFile.getParentFile().mkdirs();
                IOUtil.write((InputStream)tar, (File)newFile);
                File file = newFile;
                return file;
            }
        }
        finally {
            IOUtil.close((Closeable)tar);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, File> getSHAValuesFromArchive(File archive) throws IOException {
        HashMap<String, File> ret = new HashMap<String, File>();
        TarFile tar = new TarFile(archive);
        try {
            for (TarArchiveEntry entry : tar.getEntries()) {
                try {
                    if (!entry.isFile()) continue;
                    InputStream is = tar.getInputStream(entry);
                    String checksum = SystemUtil.calculateSHA1((InputStream)is);
                    ret.put(checksum, new File(entry.getName()));
                }
                catch (IOException | NoSuchAlgorithmException exception) {}
            }
        }
        finally {
            IOUtil.close((Closeable)tar);
        }
        return ret;
    }

    private static TarArchiveInputStream getTarArchiveInputStream(File archive) throws IOException {
        TarArchiveInputStream tar = null;
        tar = archive.getName().endsWith(".tar.gz") ? new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(archive)))) : new TarArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(archive)));
        return tar;
    }
}

