/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ipa.callgraph;

import com.ibm.wala.cast.js.types.JavaScriptTypes;
import com.ibm.wala.cast.types.AstMethodReference;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.OneLevelSiteContextSelector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;

public class JavaScriptFunctionApplyContextSelector
implements ContextSelector {
    private static final boolean USE_ONE_LEVEL = true;
    private static final TypeName APPLY_TYPE_NAME = TypeName.findOrCreate((String)"Lprologue.js/Function_prototype_apply");
    private static final TypeName CALL_TYPE_NAME = TypeName.findOrCreate((String)"Lprologue.js/Function_prototype_call");
    public static final ContextKey APPLY_NON_NULL_ARGS = new ContextKey(){};
    private final ContextSelector base;
    private ContextSelector oneLevel;

    public JavaScriptFunctionApplyContextSelector(ContextSelector base) {
        this.base = base;
        this.oneLevel = new OneLevelSiteContextSelector(base);
    }

    public IntSet getRelevantParameters(CGNode caller, CallSiteReference site) {
        if (caller.getIR().getCalls(site)[0].getNumberOfUses() >= 4) {
            return IntSetUtil.make((int[])new int[]{3}).union(this.base.getRelevantParameters(caller, site));
        }
        return this.base.getRelevantParameters(caller, site);
    }

    public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey[] receiver) {
        IClass declaringClass = callee.getDeclaringClass();
        IMethod method = declaringClass.getMethod(AstMethodReference.fnSelector);
        Context baseCtxt = this.base.getCalleeTarget(caller, site, callee, receiver);
        if (method != null) {
            TypeName tn = method.getReference().getDeclaringClass().getName();
            if (tn.equals((Object)APPLY_TYPE_NAME)) {
                InstanceKey argsList;
                boolean isNonNullArray = false;
                if (receiver.length >= 4 && (argsList = receiver[3]) != null && argsList.getConcreteType().equals(caller.getClassHierarchy().lookupClass(JavaScriptTypes.Array))) {
                    isNonNullArray = true;
                }
                if (caller.getContext().get(APPLY_NON_NULL_ARGS) == null) {
                    baseCtxt = this.oneLevel.getCalleeTarget(caller, site, callee, receiver);
                }
                return new ApplyContext(baseCtxt, isNonNullArray);
            }
            if (tn.equals((Object)CALL_TYPE_NAME)) {
                return this.oneLevel.getCalleeTarget(caller, site, callee, receiver);
            }
        }
        return baseCtxt;
    }

    public static class ApplyContext
    implements Context {
        private final Context delegate;
        private final ContextItem.Value<Boolean> isNonNullArray;

        ApplyContext(Context delegate, boolean isNonNullArray) {
            this.delegate = delegate;
            this.isNonNullArray = ContextItem.Value.make((Object)isNonNullArray);
        }

        public ContextItem get(ContextKey name) {
            if (APPLY_NON_NULL_ARGS.equals(name)) {
                return this.isNonNullArray;
            }
            return this.delegate.get(name);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.delegate.hashCode();
            result = 31 * result + this.isNonNullArray.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ApplyContext other = (ApplyContext)obj;
            if (!this.delegate.equals(other.delegate)) {
                return false;
            }
            return this.isNonNullArray.equals(other.isNonNullArray);
        }

        public String toString() {
            return "ApplyContext [delegate=" + this.delegate + ", isNonNullArray=" + this.isNonNullArray + "]";
        }
    }
}

