/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ipa.summaries;

import com.ibm.wala.cast.js.ipa.callgraph.JSCallGraphUtil;
import com.ibm.wala.cast.js.ipa.summaries.JavaScriptSummarizedFunction;
import com.ibm.wala.cast.js.ipa.summaries.JavaScriptSummary;
import com.ibm.wala.cast.js.loader.JSCallSiteReference;
import com.ibm.wala.cast.js.loader.JavaScriptLoader;
import com.ibm.wala.cast.js.ssa.JSInstructionFactory;
import com.ibm.wala.cast.js.types.JavaScriptMethods;
import com.ibm.wala.cast.js.types.JavaScriptTypes;
import com.ibm.wala.cast.types.AstMethodReference;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.MethodSummary;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Pair;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class JavaScriptConstructorFunctions {
    private final Map<Object, IMethod> constructors = HashMapFactory.make();
    private final IClassHierarchy cha;
    private int ctorCount = 0;

    public JavaScriptConstructorFunctions(IClassHierarchy cha) {
        this.cha = cha;
    }

    private IMethod record(Object key, IMethod m) {
        this.constructors.put(key, m);
        return m;
    }

    private IMethod makeNullaryValueConstructor(IClass cls, Object value) {
        JSInstructionFactory insts = (JSInstructionFactory)cls.getClassLoader().getInstructionFactory();
        MethodReference ref = JavaScriptMethods.makeCtorReference(cls.getReference());
        JavaScriptSummary S = new JavaScriptSummary(ref, 1);
        S.addStatement((SSAInstruction)insts.GetInstruction(S.getNumberOfStatements(), 4, 1, "prototype"));
        S.getNextProgramCounter();
        S.addStatement((SSAInstruction)insts.NewInstruction(S.getNumberOfStatements(), 5, NewSiteReference.make((int)S.getNextProgramCounter(), (TypeReference)cls.getReference())));
        S.addStatement(insts.SetPrototype(S.getNumberOfStatements(), 5, 4));
        S.getNextProgramCounter();
        S.addConstant(new Integer(8), new ConstantValue(value));
        S.addStatement((SSAInstruction)insts.PutInstruction(S.getNumberOfStatements(), 5, 8, "$value"));
        S.getNextProgramCounter();
        S.addStatement((SSAInstruction)insts.ReturnInstruction(S.getNumberOfStatements(), 5, false));
        S.getNextProgramCounter();
        return new JavaScriptConstructor(ref, (MethodSummary)S, cls, cls);
    }

    private IMethod makeUnaryValueConstructor(IClass cls) {
        JSInstructionFactory insts = (JSInstructionFactory)cls.getClassLoader().getInstructionFactory();
        MethodReference ref = JavaScriptMethods.makeCtorReference(cls.getReference());
        JavaScriptSummary S = new JavaScriptSummary(ref, 2);
        S.addStatement((SSAInstruction)insts.GetInstruction(S.getNumberOfStatements(), 5, 1, "prototype"));
        S.getNextProgramCounter();
        S.addStatement((SSAInstruction)insts.NewInstruction(S.getNumberOfStatements(), 6, NewSiteReference.make((int)S.getNextProgramCounter(), (TypeReference)cls.getReference())));
        S.addStatement(insts.SetPrototype(S.getNumberOfStatements(), 6, 5));
        S.getNextProgramCounter();
        S.addStatement((SSAInstruction)insts.PutInstruction(S.getNumberOfStatements(), 6, 2, "$value"));
        S.getNextProgramCounter();
        S.addStatement((SSAInstruction)insts.ReturnInstruction(S.getNumberOfStatements(), 6, false));
        S.getNextProgramCounter();
        return new JavaScriptConstructor(ref, (MethodSummary)S, cls, cls);
    }

    private IMethod makeValueConstructor(IClass cls, int nargs, Object value) {
        if (nargs == 0 || nargs == 1) {
            Pair key = Pair.make((Object)cls, (Object)new Integer(nargs));
            if (this.constructors.containsKey(key)) {
                return this.constructors.get(key);
            }
            return this.record(key, nargs == 0 ? this.makeNullaryValueConstructor(cls, value) : this.makeUnaryValueConstructor(cls));
        }
        return null;
    }

    private IMethod makeNullaryObjectConstructor(IClass cls) {
        JSInstructionFactory insts = (JSInstructionFactory)cls.getClassLoader().getInstructionFactory();
        MethodReference ref = JavaScriptMethods.makeCtorReference(JavaScriptTypes.Object);
        JavaScriptSummary S = new JavaScriptSummary(ref, 1);
        S.addStatement((SSAInstruction)insts.GetInstruction(S.getNumberOfStatements(), 4, 1, "prototype"));
        S.getNextProgramCounter();
        S.addStatement((SSAInstruction)insts.NewInstruction(S.getNumberOfStatements(), 5, NewSiteReference.make((int)S.getNextProgramCounter(), (TypeReference)JavaScriptTypes.Object)));
        S.addStatement(insts.SetPrototype(S.getNumberOfStatements(), 5, 4));
        S.getNextProgramCounter();
        S.addStatement((SSAInstruction)insts.ReturnInstruction(S.getNumberOfStatements(), 5, false));
        S.getNextProgramCounter();
        return new JavaScriptConstructor(ref, (MethodSummary)S, cls, this.cha.lookupClass(JavaScriptTypes.Object));
    }

    private IMethod makeUnaryObjectConstructor(IClass cls) {
        JSInstructionFactory insts = (JSInstructionFactory)cls.getClassLoader().getInstructionFactory();
        MethodReference ref = JavaScriptMethods.makeCtorReference(JavaScriptTypes.Object);
        JavaScriptSummary S = new JavaScriptSummary(ref, 2);
        S.addStatement((SSAInstruction)insts.ReturnInstruction(S.getNumberOfStatements(), 2, false));
        S.getNextProgramCounter();
        return new JavaScriptConstructor(ref, (MethodSummary)S, cls, this.cha.lookupClass(JavaScriptTypes.Object));
    }

    private IMethod makeObjectConstructor(IClass cls, int nargs) {
        if (nargs == 0 || nargs == 1) {
            Pair key = Pair.make((Object)cls, (Object)new Integer(nargs));
            if (this.constructors.containsKey(key)) {
                return this.constructors.get(key);
            }
            return this.record(key, nargs == 0 ? this.makeNullaryObjectConstructor(cls) : this.makeUnaryObjectConstructor(cls));
        }
        return null;
    }

    private IMethod makeObjectCall(IClass cls, int nargs) {
        assert (nargs == 0);
        Pair key = Pair.make((Object)cls, (Object)new Integer(nargs));
        if (this.constructors.containsKey(key)) {
            return this.constructors.get(key);
        }
        return this.record(key, this.makeNullaryObjectConstructor(cls));
    }

    private IMethod makeArrayLengthConstructor(IClass cls) {
        JSInstructionFactory insts = (JSInstructionFactory)cls.getClassLoader().getInstructionFactory();
        MethodReference ref = JavaScriptMethods.makeCtorReference(JavaScriptTypes.Array);
        JavaScriptSummary S = new JavaScriptSummary(ref, 2);
        S.addStatement((SSAInstruction)insts.GetInstruction(S.getNumberOfStatements(), 5, 1, "prototype"));
        S.getNextProgramCounter();
        S.addStatement((SSAInstruction)insts.NewInstruction(S.getNumberOfStatements(), 6, NewSiteReference.make((int)S.getNextProgramCounter(), (TypeReference)JavaScriptTypes.Array)));
        S.addStatement(insts.SetPrototype(S.getNumberOfStatements(), 6, 5));
        S.getNextProgramCounter();
        S.addStatement((SSAInstruction)insts.PutInstruction(S.getNumberOfStatements(), 6, 2, "length"));
        S.getNextProgramCounter();
        S.addStatement((SSAInstruction)insts.ReturnInstruction(S.getNumberOfStatements(), 6, false));
        S.getNextProgramCounter();
        return new JavaScriptConstructor(ref, (MethodSummary)S, cls, this.cha.lookupClass(JavaScriptTypes.Array));
    }

    private IMethod makeArrayContentsConstructor(IClass cls, int nargs) {
        JSInstructionFactory insts = (JSInstructionFactory)cls.getClassLoader().getInstructionFactory();
        MethodReference ref = JavaScriptMethods.makeCtorReference(JavaScriptTypes.Array);
        JavaScriptSummary S = new JavaScriptSummary(ref, nargs + 1);
        S.addConstant(new Integer(nargs + 3), new ConstantValue((Object)"prototype"));
        S.addStatement((SSAInstruction)insts.PropertyRead(S.getNumberOfStatements(), nargs + 4, 1, nargs + 3));
        S.getNextProgramCounter();
        S.addStatement((SSAInstruction)insts.NewInstruction(S.getNumberOfStatements(), nargs + 5, NewSiteReference.make((int)S.getNextProgramCounter(), (TypeReference)JavaScriptTypes.Array)));
        S.addStatement(insts.SetPrototype(S.getNumberOfStatements(), nargs + 5, nargs + 4));
        S.getNextProgramCounter();
        S.addConstant(new Integer(nargs + 7), new ConstantValue(nargs));
        S.addStatement((SSAInstruction)insts.PutInstruction(S.getNumberOfStatements(), nargs + 5, nargs + 7, "length"));
        S.getNextProgramCounter();
        int vn = nargs + 9;
        int i = 0;
        while (i < nargs) {
            S.addConstant(new Integer(vn), new ConstantValue(i));
            S.addStatement((SSAInstruction)insts.PropertyWrite(S.getNumberOfStatements(), nargs + 5, vn, i + 1));
            S.getNextProgramCounter();
            ++i;
            vn += 2;
        }
        S.addStatement((SSAInstruction)insts.ReturnInstruction(S.getNumberOfStatements(), 5, false));
        S.getNextProgramCounter();
        return new JavaScriptConstructor(ref, (MethodSummary)S, cls, this.cha.lookupClass(JavaScriptTypes.Array));
    }

    private IMethod makeArrayConstructor(IClass cls, int nargs) {
        Pair key = Pair.make((Object)cls, (Object)new Integer(nargs));
        if (this.constructors.containsKey(key)) {
            return this.constructors.get(key);
        }
        return this.record(key, nargs == 1 ? this.makeArrayLengthConstructor(cls) : this.makeArrayContentsConstructor(cls, nargs));
    }

    private IMethod makeNullaryStringCall(IClass cls) {
        JSInstructionFactory insts = (JSInstructionFactory)cls.getClassLoader().getInstructionFactory();
        MethodReference ref = AstMethodReference.fnReference((TypeReference)JavaScriptTypes.String);
        JavaScriptSummary S = new JavaScriptSummary(ref, 1);
        S.addConstant(new Integer(2), new ConstantValue((Object)""));
        S.addStatement((SSAInstruction)insts.ReturnInstruction(S.getNumberOfStatements(), 2, false));
        S.getNextProgramCounter();
        return new JavaScriptConstructor(ref, (MethodSummary)S, cls, this.cha.lookupClass(JavaScriptTypes.String));
    }

    private IMethod makeUnaryStringCall(IClass cls) {
        JSInstructionFactory insts = (JSInstructionFactory)cls.getClassLoader().getInstructionFactory();
        MethodReference ref = AstMethodReference.fnReference((TypeReference)JavaScriptTypes.String);
        JavaScriptSummary S = new JavaScriptSummary(ref, 2);
        S.addStatement((SSAInstruction)insts.GetInstruction(S.getNumberOfStatements(), 4, 2, "toString"));
        S.getNextProgramCounter();
        JSCallSiteReference cs = new JSCallSiteReference(S.getNextProgramCounter());
        S.addStatement((SSAInstruction)insts.Invoke(S.getNumberOfStatements(), 4, 5, new int[]{2}, 6, (CallSiteReference)cs));
        S.addStatement((SSAInstruction)insts.ReturnInstruction(S.getNumberOfStatements(), 5, false));
        S.getNextProgramCounter();
        return new JavaScriptConstructor(ref, (MethodSummary)S, cls, this.cha.lookupClass(JavaScriptTypes.String));
    }

    private IMethod makeStringCall(IClass cls, int nargs) {
        assert (nargs == 0 || nargs == 1);
        Pair key = Pair.make((Object)cls, (Object)new Integer(nargs));
        if (this.constructors.containsKey(key)) {
            return this.constructors.get(key);
        }
        return this.record(key, nargs == 0 ? this.makeNullaryStringCall(cls) : this.makeUnaryStringCall(cls));
    }

    private IMethod makeNullaryNumberCall(IClass cls) {
        JSInstructionFactory insts = (JSInstructionFactory)cls.getClassLoader().getInstructionFactory();
        MethodReference ref = AstMethodReference.fnReference((TypeReference)JavaScriptTypes.Number);
        JavaScriptSummary S = new JavaScriptSummary(ref, 1);
        S.addConstant(new Integer(2), new ConstantValue(0.0));
        S.addStatement((SSAInstruction)insts.ReturnInstruction(S.getNumberOfStatements(), 2, false));
        S.getNextProgramCounter();
        return new JavaScriptConstructor(ref, (MethodSummary)S, cls, this.cha.lookupClass(JavaScriptTypes.Number));
    }

    private IMethod makeUnaryNumberCall(IClass cls) {
        JSInstructionFactory insts = (JSInstructionFactory)cls.getClassLoader().getInstructionFactory();
        MethodReference ref = AstMethodReference.fnReference((TypeReference)JavaScriptTypes.Number);
        JavaScriptSummary S = new JavaScriptSummary(ref, 2);
        S.addStatement((SSAInstruction)insts.GetInstruction(S.getNumberOfStatements(), 4, 2, "toNumber"));
        S.getNextProgramCounter();
        JSCallSiteReference cs = new JSCallSiteReference(S.getNextProgramCounter());
        S.addStatement((SSAInstruction)insts.Invoke(S.getNumberOfStatements(), 4, 5, new int[]{2}, 6, (CallSiteReference)cs));
        S.addStatement((SSAInstruction)insts.ReturnInstruction(S.getNumberOfStatements(), 5, false));
        S.getNextProgramCounter();
        return new JavaScriptConstructor(ref, (MethodSummary)S, cls, this.cha.lookupClass(JavaScriptTypes.Number));
    }

    private IMethod makeNumberCall(IClass cls, int nargs) {
        assert (nargs == 0 || nargs == 1);
        Pair key = Pair.make((Object)cls, (Object)new Integer(nargs));
        if (this.constructors.containsKey(key)) {
            return this.constructors.get(key);
        }
        return this.record(key, nargs == 0 ? this.makeNullaryNumberCall(cls) : this.makeUnaryNumberCall(cls));
    }

    private IMethod makeFunctionConstructor(IClass receiver, IClass cls) {
        JSInstructionFactory insts = (JSInstructionFactory)cls.getClassLoader().getInstructionFactory();
        Pair tableKey = Pair.make((Object)receiver, (Object)cls);
        if (this.constructors.containsKey(tableKey)) {
            return this.constructors.get(tableKey);
        }
        MethodReference ref = JavaScriptMethods.makeCtorReference(receiver.getReference());
        JavaScriptSummary S = new JavaScriptSummary(ref, 1);
        S.addStatement((SSAInstruction)insts.GetInstruction(S.getNumberOfStatements(), 4, 1, "prototype"));
        S.getNextProgramCounter();
        S.addStatement((SSAInstruction)insts.NewInstruction(S.getNumberOfStatements(), 5, NewSiteReference.make((int)S.getNextProgramCounter(), (TypeReference)cls.getReference())));
        S.addStatement((SSAInstruction)insts.NewInstruction(S.getNumberOfStatements(), 7, NewSiteReference.make((int)S.getNextProgramCounter(), (TypeReference)JavaScriptTypes.Object)));
        S.addStatement(insts.SetPrototype(S.getNumberOfStatements(), 5, 4));
        S.getNextProgramCounter();
        S.addStatement((SSAInstruction)insts.PutInstruction(S.getNumberOfStatements(), 5, 7, "prototype"));
        S.getNextProgramCounter();
        S.addStatement((SSAInstruction)insts.PutInstruction(S.getNumberOfStatements(), 7, 5, "constructor"));
        S.getNextProgramCounter();
        S.addStatement((SSAInstruction)insts.ReturnInstruction(S.getNumberOfStatements(), 5, false));
        S.getNextProgramCounter();
        if (receiver != cls) {
            return this.record(tableKey, (IMethod)new JavaScriptConstructor(ref, S, receiver, cls, "(" + cls.getReference().getName() + ")"));
        }
        return this.record(tableKey, (IMethod)new JavaScriptConstructor(ref, (MethodSummary)S, receiver, cls));
    }

    private IMethod makeFunctionConstructor(IR callerIR, SSAAbstractInvokeInstruction callStmt, IClass cls, int nargs) {
        SymbolTable ST = callerIR.getSymbolTable();
        if (nargs == 0) {
            return this.makeFunctionConstructor(cls, cls);
        }
        if (nargs == 1) {
            if (ST.isStringConstant(callStmt.getUse(1))) {
                String stringValue = ST.getStringValue(callStmt.getUse(1));
                if (stringValue == null || stringValue.trim().length() == 0) {
                    return this.makeFunctionConstructor(cls, cls);
                }
                TypeReference ref = TypeReference.findOrCreate((ClassLoaderReference)JavaScriptTypes.jsLoader, (TypeName)TypeName.string2TypeName((String)ST.getStringValue(callStmt.getUse(1))));
                IClass cls2 = this.cha.lookupClass(ref);
                if (cls2 != null) {
                    return this.makeFunctionConstructor(cls, cls2);
                }
            }
            return this.makeFunctionConstructor(cls, cls);
        }
        assert (nargs > 1);
        JavaScriptLoader cl = (JavaScriptLoader)this.cha.getLoader(JavaScriptTypes.jsLoader);
        for (int i = 1; i < callStmt.getNumberOfUses(); ++i) {
            if (ST.isStringConstant(callStmt.getUse(i))) continue;
            return this.makeFunctionConstructor(cls, cls);
        }
        StringBuffer fun = new StringBuffer("function _fromctor (");
        for (int j = 1; j < callStmt.getNumberOfUses() - 1; ++j) {
            if (j != 1) {
                fun.append(",");
            }
            fun.append(ST.getStringValue(callStmt.getUse(j)));
        }
        fun.append(") {");
        fun.append(ST.getStringValue(callStmt.getUse(callStmt.getNumberOfUses() - 1)));
        fun.append("}");
        try {
            String fileName = "ctor$" + ++this.ctorCount;
            File f = new File(System.getProperty("java.io.tmpdir") + File.separator + fileName);
            FileWriter FO = new FileWriter(f);
            FO.write(fun.toString());
            FO.close();
            Set<String> fnNames = JSCallGraphUtil.loadAdditionalFile(this.cha, cl, fileName, f.toURI().toURL());
            IClass fcls = null;
            for (String nm : fnNames) {
                if (!nm.endsWith("_fromctor")) continue;
                fcls = cl.lookupClass(nm, this.cha);
            }
            assert (fcls != null) : "cannot find class for " + fileName + " in " + f;
            f.delete();
            if (fcls != null) {
                return this.makeFunctionConstructor(cls, fcls);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.makeFunctionConstructor(cls, cls);
    }

    private IMethod makeFunctionObjectConstructor(IClass cls, int nargs) {
        JSInstructionFactory insts = (JSInstructionFactory)cls.getClassLoader().getInstructionFactory();
        Pair key = Pair.make((Object)cls, (Object)new Integer(nargs));
        if (this.constructors.containsKey(key)) {
            return this.constructors.get(key);
        }
        MethodReference ref = JavaScriptMethods.makeCtorReference(cls.getReference());
        JavaScriptSummary S = new JavaScriptSummary(ref, nargs + 1);
        S.addStatement((SSAInstruction)insts.GetInstruction(S.getNumberOfStatements(), nargs + 4, 1, "prototype"));
        S.getNextProgramCounter();
        S.addStatement((SSAInstruction)insts.NewInstruction(S.getNumberOfStatements(), nargs + 5, NewSiteReference.make((int)S.getNextProgramCounter(), (TypeReference)JavaScriptTypes.Object)));
        S.addStatement(insts.SetPrototype(S.getNumberOfStatements(), nargs + 5, nargs + 4));
        S.getNextProgramCounter();
        JSCallSiteReference cs = new JSCallSiteReference(S.getNextProgramCounter());
        int[] args = new int[nargs + 1];
        args[0] = nargs + 5;
        for (int i = 0; i < nargs; ++i) {
            args[i + 1] = i + 2;
        }
        S.addStatement((SSAInstruction)insts.Invoke(S.getNumberOfStatements(), 1, nargs + 7, args, nargs + 8, (CallSiteReference)cs));
        int pc = S.getNextProgramCounter();
        S.addConstant(nargs + 9, null);
        S.addStatement((SSAInstruction)insts.ConditionalBranchInstruction(S.getNumberOfStatements(), (IConditionalBranchInstruction.IOperator)IConditionalBranchInstruction.Operator.EQ, JavaScriptTypes.Root, nargs + 7, nargs + 9, pc + 2));
        S.getNextProgramCounter();
        S.addStatement((SSAInstruction)insts.ReturnInstruction(S.getNumberOfStatements(), nargs + 7, false));
        S.getNextProgramCounter();
        S.addStatement((SSAInstruction)insts.ReturnInstruction(S.getNumberOfStatements(), nargs + 5, false));
        S.getNextProgramCounter();
        return this.record(key, (IMethod)new JavaScriptConstructor(ref, (MethodSummary)S, cls, cls));
    }

    public IMethod findOrCreateConstructorMethod(IR callerIR, SSAAbstractInvokeInstruction callStmt, IClass receiver, int nargs) {
        if (receiver.getReference().equals((Object)JavaScriptTypes.Object)) {
            return this.makeObjectConstructor(receiver, nargs);
        }
        if (receiver.getReference().equals((Object)JavaScriptTypes.Array)) {
            return this.makeArrayConstructor(receiver, nargs);
        }
        if (receiver.getReference().equals((Object)JavaScriptTypes.StringObject)) {
            return this.makeValueConstructor(receiver, nargs, "");
        }
        if (receiver.getReference().equals((Object)JavaScriptTypes.BooleanObject)) {
            assert (nargs == 1);
            return this.makeValueConstructor(receiver, nargs, null);
        }
        if (receiver.getReference().equals((Object)JavaScriptTypes.NumberObject)) {
            return this.makeValueConstructor(receiver, nargs, new Integer(0));
        }
        if (receiver.getReference().equals((Object)JavaScriptTypes.Function)) {
            return this.makeFunctionConstructor(callerIR, callStmt, receiver, nargs);
        }
        if (this.cha.isSubclassOf(receiver, this.cha.lookupClass(JavaScriptTypes.CodeBody))) {
            return this.makeFunctionObjectConstructor(receiver, nargs);
        }
        return null;
    }

    public IMethod findOrCreateCallMethod(IR callerIR, SSAAbstractInvokeInstruction callStmt, IClass receiver, int nargs) {
        if (receiver.getReference().equals((Object)JavaScriptTypes.Object)) {
            return this.makeObjectCall(receiver, nargs);
        }
        if (receiver.getReference().equals((Object)JavaScriptTypes.Array)) {
            return this.makeArrayConstructor(receiver, nargs);
        }
        if (receiver.getReference().equals((Object)JavaScriptTypes.StringObject)) {
            return this.makeStringCall(receiver, nargs);
        }
        if (receiver.getReference().equals((Object)JavaScriptTypes.NumberObject)) {
            return this.makeNumberCall(receiver, nargs);
        }
        if (receiver.getReference().equals((Object)JavaScriptTypes.Function)) {
            return this.makeFunctionConstructor(callerIR, callStmt, receiver, nargs);
        }
        return null;
    }

    public static class JavaScriptConstructor
    extends JavaScriptSummarizedFunction {
        private final String toStringExtra;
        private final IClass constructorForType;

        private JavaScriptConstructor(MethodReference ref, MethodSummary summary, IClass declaringClass, IClass constructorForType, String toStringExtra) {
            super(ref, summary, declaringClass);
            this.toStringExtra = toStringExtra;
            this.constructorForType = constructorForType;
        }

        private JavaScriptConstructor(MethodReference ref, MethodSummary summary, IClass declaringClass, IClass constructorForType) {
            this(ref, summary, declaringClass, constructorForType, "");
        }

        public String toString() {
            return "<ctor for " + this.getReference().getDeclaringClass() + this.toStringExtra + ">";
        }

        public IClass constructedType() {
            return this.constructorForType;
        }
    }
}

