/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.util;

import com.ibm.wala.cast.js.loader.JavaScriptLoader;
import com.ibm.wala.cast.js.types.JavaScriptMethods;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.types.AstMethodReference;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Util;
import com.ibm.wala.util.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CallGraph2JSON {
    public static boolean IGNORE_HARNESS = true;

    public static String serialize(CallGraph cg) {
        Map<String, Set<String>> edges = CallGraph2JSON.extractEdges(cg);
        return CallGraph2JSON.toJSON(edges);
    }

    public static Map<String, Set<String>> extractEdges(CallGraph cg) {
        HashMap edges = HashMapFactory.make();
        for (CGNode nd : cg) {
            if (!CallGraph2JSON.isRealFunction(nd.getMethod())) continue;
            AstMethod method = (AstMethod)nd.getMethod();
            Iterator iter = nd.iterateCallSites();
            while (iter.hasNext()) {
                CallSiteReference callsite = (CallSiteReference)iter.next();
                Set targets = Util.mapToSet((Collection)cg.getPossibleTargets(nd, callsite), (Function)new Function<CGNode, IMethod>(){

                    public IMethod apply(CGNode nd) {
                        return nd.getMethod();
                    }
                });
                CallGraph2JSON.serializeCallSite(method, callsite, targets, edges);
            }
        }
        return edges;
    }

    public static void serializeCallSite(AstMethod method, CallSiteReference callsite, Set<IMethod> targets, Map<String, Set<String>> edges) {
        Set targetNames = MapUtil.findOrCreateSet(edges, (Object)CallGraph2JSON.ppPos(method, method.getSourcePosition(callsite.getProgramCounter())));
        for (IMethod target : targets) {
            if (!CallGraph2JSON.isRealFunction(target = CallGraph2JSON.getCallTargetMethod(target))) continue;
            targetNames.add(CallGraph2JSON.ppPos((AstMethod)target, ((AstMethod)target).getSourcePosition()));
        }
    }

    private static IMethod getCallTargetMethod(IMethod method) {
        if (method.getName().equals((Object)JavaScriptMethods.ctorAtom) && (method = method.getDeclaringClass().getMethod(AstMethodReference.fnSelector)) != null) {
            return method;
        }
        return method;
    }

    public static boolean isRealFunction(IMethod method) {
        if (method instanceof AstMethod) {
            String methodName = method.getDeclaringClass().getName().toString();
            if (methodName.contains("/make_node")) {
                return false;
            }
            if (IGNORE_HARNESS) {
                for (String bootstrapFile : JavaScriptLoader.bootstrapFileNames) {
                    if (!methodName.startsWith("L" + bootstrapFile + "/")) continue;
                    return false;
                }
            }
            return method.getName().equals((Object)AstMethodReference.fnAtom);
        }
        return false;
    }

    private static String ppPos(AstMethod method, CAstSourcePositionMap.Position pos) {
        String file = pos.getURL().getFile();
        file = file.substring(file.lastIndexOf(47) + 1);
        int line = pos.getFirstLine();
        int start_offset = pos.getFirstOffset();
        int end_offset = pos.getLastOffset();
        return file + "@" + line + ":" + start_offset + "-" + end_offset;
    }

    public static String toJSON(Map<String, Set<String>> map) {
        StringBuffer res = new StringBuffer();
        res.append("{\n");
        res.append(CallGraph2JSON.joinWith(Util.mapToSet(map.entrySet(), (Function)new Function<Map.Entry<String, Set<String>>, String>(){

            public String apply(Map.Entry<String, Set<String>> e) {
                StringBuffer res = new StringBuffer();
                if (e.getValue().size() > 0) {
                    res.append("    \"" + e.getKey() + "\": [\n");
                    res.append(CallGraph2JSON.joinWith(Util.mapToSet((Collection)e.getValue(), (Function)new Function<String, String>(){

                        public String apply(String str) {
                            return "        \"" + str + "\"";
                        }
                    }), ",\n"));
                    res.append("\n    ]");
                }
                return res.length() == 0 ? null : res.toString();
            }
        }), ",\n"));
        res.append("\n}");
        return res.toString();
    }

    private static String joinWith(Iterable<String> lst, String sep) {
        StringBuffer res = new StringBuffer();
        ArrayList<String> strings = new ArrayList<String>();
        for (String s : lst) {
            if (s == null) continue;
            strings.add(s);
        }
        boolean fst = true;
        for (String s : strings) {
            if (fst) {
                fst = false;
            } else {
                res.append(sep);
            }
            res.append(s);
        }
        return res.toString();
    }
}

