/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.data;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.VdbArtifact;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.provider.method.MethodProvider;
import java.util.Collection;
import java.util.TreeMap;

public class VdbClass
extends VdbArtifact
implements Comparable<VdbClass> {
    private TreeMap<String, Method> m_methods;

    public VdbClass(String name, Language.LANGUAGE lang) {
        this.setClassName(name);
        this.setLang(lang);
    }

    public VdbClass(VdbClass c) throws BadMarkupException {
        this.setLang(c.getLang());
        this.setPackageName(c.getPackageName());
        this.setFramework(c.getFramework());
        this.merge(c);
    }

    public Collection<Method> getMethods() {
        return this.getMethodsMap().values();
    }

    public TreeMap<String, Method> getMethodsMap() {
        if (this.m_methods == null) {
            this.m_methods = new TreeMap();
        }
        return this.m_methods;
    }

    public Method getMethod(String sig) {
        return this.getMethodsMap().get(sig);
    }

    public boolean addMethod(Method method) throws BadMarkupException {
        if (this.getLang() == null) {
            throw new BadMarkupException("VdbClass language is null", new Object[0]);
        }
        if (method.getLang() == null) {
            method.setLang(this.getLang());
        }
        if (!this.getLang().equals((Object)method.getLang())) {
            throw new BadMarkupException("Method language {0} and VdbClass language {1} need to be the same", method.getLang(), this.getLang());
        }
        if (!this.getClassName().equals(method.getClassName())) {
            throw new BadMarkupException("Method classname {0} and VdbClass name {1} need to be the same", method.getClassName(), this.getClassName());
        }
        if (!this.getMethodsMap().containsKey(method.getSignature())) {
            this.getMethodsMap().put(method.getSignature(), method);
            return true;
        }
        if (this.getMethodsMap().get(method.getSignature()).equals(method)) {
            return false;
        }
        if (!this.getMethodsMap().get(method.getSignature()).isMarkedUp() && method.isMarkedUp()) {
            this.getMethodsMap().remove(method.getSignature());
            this.getMethodsMap().put(method.getSignature(), method);
            return true;
        }
        if (method.isMarkedUp()) {
            return this.getMethodsMap().get(method.getSignature()).merge(method);
        }
        return false;
    }

    public boolean deleteMethod(Method m) {
        if (this.getMethodsMap().containsKey(m.getSignature())) {
            this.getMethodsMap().remove(m.getSignature());
            return true;
        }
        return false;
    }

    public boolean deleteMethod(String sig) {
        if (this.getMethodsMap().containsKey(sig)) {
            this.getMethodsMap().remove(sig);
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        VdbClass c = (VdbClass)obj;
        return this.compareTo(c) == 0;
    }

    @Override
    public int compareTo(VdbClass o) {
        if (this.getClassName().compareToIgnoreCase(o.getClassName()) == 0) {
            if (this.getMethodsMap().size() != o.getMethodsMap().size()) {
                if (this.getMethodsMap().size() > o.getMethodsMap().size()) {
                    return 1;
                }
                if (this.getMethodsMap().size() < o.getMethodsMap().size()) {
                    return -1;
                }
            }
            for (Method m : this.getMethods()) {
                if (o.getMethod(m.getSignature()) == null) {
                    return 1;
                }
                if (m.compareTo(o.getMethod(m.getSignature())) == 0) continue;
                return m.compareTo(o.getMethod(m.getSignature()));
            }
            for (Method m : o.getMethods()) {
                if (this.getMethod(m.getSignature()) == null) {
                    return -1;
                }
                if (m.compareTo(o.getMethod(m.getSignature())) == 0) continue;
                return m.compareTo(o.getMethod(m.getSignature()));
            }
        }
        return this.getClassName().compareToIgnoreCase(o.getClassName());
    }

    @Override
    public void replace(VdbArtifact e) throws BadMarkupException {
        if (e instanceof VdbClass) {
            this.reset();
            VdbClass c = (VdbClass)e;
            this.setClassName(c.getClassName());
            this.setPackageName(c.getPackageName());
            this.merge(c);
        }
    }

    @Override
    public boolean merge(VdbArtifact e) throws BadMarkupException {
        boolean _ret = false;
        if (e instanceof VdbClass) {
            VdbClass c = (VdbClass)e;
            for (Method m : c.getMethods()) {
                try {
                    Method newM = MethodProvider.getMethod(m);
                    if (!this.addMethod(newM)) continue;
                    _ret = true;
                }
                catch (VDBException e1) {
                    throw new BadMarkupException(e1.getLocalizedMessage(), new Object[0]);
                }
            }
        }
        return _ret;
    }

    @Override
    public void reset() {
        this.m_methods = null;
    }

    public boolean isFullyMarkedUp() {
        if (this.getMethods().size() == 0) {
            return false;
        }
        for (Method m : this.getMethods()) {
            if (m.isMarkedUp()) continue;
            return false;
        }
        return true;
    }
}

