/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.method.audit;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.data.VdbPackage;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.misc.VDBConstants;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.appscan.vdb.provider.method.MethodProvider;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;

public class BaseAuditProvider
extends MethodProvider {
    private String m_date_string;

    public BaseAuditProvider(Language.LANGUAGE lang, VDBEnums.BUCKET b, String date_format) {
        super(lang, b);
        this.m_date_string = date_format;
    }

    public String getDateString() {
        return this.m_date_string;
    }

    public Date getDate() throws VDBGeneralException {
        try {
            return VDBConstants.AUDIT_DATE_FORMAT.parse(this.m_date_string);
        }
        catch (ParseException e) {
            throw new VDBGeneralException(e);
        }
    }

    @Override
    public void saveVdb(Vdb v) throws VDBGeneralException {
        VdbProvider.getDataProvider(this.getLang()).saveAuditVdb(this.getDate(), this.getBucket(), v);
    }

    @Override
    public boolean deletePackage(VdbPackage p) throws VDBGeneralException {
        return VdbProvider.getDataProvider(this.getLang()).deleteAuditPackage(this.getDate(), this.getBucket(), p);
    }

    @Override
    public void deleteNcf() throws VDBGeneralException {
        VdbProvider.getDataProvider(this.getLang()).deleteAuditNonClassFuncFile(this.getDate(), this.getBucket());
    }

    @Override
    public Vdb getVdb(String package_name) throws VDBGeneralException {
        return VdbProvider.getDataProvider(this.getLang()).getAuditVdb(this.getDate(), this.getBucket(), package_name);
    }

    @Override
    public Vdb getVdb(VdbPackage p) throws VDBGeneralException {
        return VdbProvider.getDataProvider(this.getLang()).getAuditVdb(this.getDate(), this.getBucket(), p.getPackageName());
    }

    @Override
    public Vdb getNonClassFuncsVdb() throws VDBGeneralException {
        return VdbProvider.getDataProvider(this.getLang()).getAuditNonClassFuncsVdb(this.getDate(), this.getBucket());
    }

    @Override
    public Set<String> getPackages() throws VDBException {
        return VdbProvider.getDataProvider(this.getLang()).getAuditPackages(this.getDate(), this.getBucket());
    }

    @Override
    public ArrayList<String> getClassesForPackage(String package_name) throws VDBException {
        return VdbProvider.getDataProvider(this.getLang()).getAuditClassesForPackage(this.getDate(), this.getBucket(), package_name);
    }

    @Override
    public ArrayList<String> getMethodsForClass(String package_name, String class_name) throws VDBException {
        return VdbProvider.getDataProvider(this.getLang()).getAuditMethodsForClass(this.getDate(), this.getBucket(), package_name, class_name);
    }

    @Override
    public Set<String> getNonClassFunctions() throws VDBException {
        return VdbProvider.getDataProvider(this.getLang()).getAuditNonClassFunctions(this.getDate(), this.getBucket());
    }
}

