/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.rest;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.appscan.vdb.provider.rest.BaseRestClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public abstract class BaseMarkupRestClient
extends BaseRestClient {
    private Language.LANGUAGE m_lang;
    private HashSet<String> m_classes = new HashSet();
    private HashSet<String> m_methods = new HashSet();

    protected BaseMarkupRestClient(Language.LANGUAGE lang, String host, String port, boolean secure) {
        super(host, port, secure);
        this.m_lang = lang;
    }

    @Override
    protected String getApplicationBase() {
        return "sast/markup";
    }

    protected abstract String getListBase();

    protected abstract String getVdbBase();

    public Vdb getZoneMarkup(File rules_wizard_file, String id, Language.LANGUAGE lang) throws VDBGeneralException {
        Vdb ret = null;
        try {
            HttpURLConnection conn = this.getConnection(this.getVdbBase() + "/" + lang.toString() + "/get-zone-markup", "POST");
            Vdb sigs = VdbProvider.getVdbFromSignatureLog(lang, rules_wizard_file);
            this.addVdbPart(conn.getOutputStream(), sigs);
            if (conn.getResponseCode() != 200) {
                if (conn.getResponseCode() == 409) {
                    throw new VDBGeneralException("Error loading VDB details on REST server", new Object[0]);
                }
                if (conn.getResponseCode() == 400) {
                    throw new VDBGeneralException("Invalid request of REST server", new Object[0]);
                }
                throw new VDBGeneralException("Server error during signature vdb retrieval: " + conn.getResponseCode(), new Object[0]);
            }
            ret = this.getVdb(conn.getInputStream());
            conn.disconnect();
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
        return ret;
    }

    public int uploadVdb(Vdb v) throws VDBGeneralException {
        try {
            HttpURLConnection conn = this.getConnection(this.getVdbBase() + "/" + v.getLang().toString() + "/add", "POST");
            this.addVdbPart(conn.getOutputStream(), v);
            ArrayList<String> response = new ArrayList<String>();
            if (conn.getResponseCode() == 200) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    response.add(line);
                }
                reader.close();
                conn.disconnect();
                return Integer.parseInt((String)response.get(0));
            }
            if (conn.getResponseCode() == 204) {
                throw new VDBGeneralException("Invalid Vdb structure", new Object[0]);
            }
            if (conn.getResponseCode() == 400) {
                throw new VDBGeneralException("Rest server error during upload", new Object[0]);
            }
            throw new VDBGeneralException("Server error during upload: " + conn.getResponseCode(), new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }

    public int uploadNonAuditVdb(Vdb v) throws VDBGeneralException {
        if (v == null) {
            return 0;
        }
        if (!v.hasMarkedUpMethods()) {
            return 0;
        }
        try {
            HttpURLConnection conn = this.getConnection(this.getVdbBase() + "/" + v.getLang().toString() + "/add_non_audit", "POST");
            this.addVdbPart(conn.getOutputStream(), v);
            ArrayList<String> response = new ArrayList<String>();
            if (conn.getResponseCode() == 200) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    response.add(line);
                }
                reader.close();
                conn.disconnect();
                return Integer.parseInt((String)response.get(0));
            }
            if (conn.getResponseCode() == 204) {
                throw new VDBGeneralException("Invalid Vdb structure", new Object[0]);
            }
            if (conn.getResponseCode() == 400) {
                throw new VDBGeneralException("Rest server error during upload", new Object[0]);
            }
            throw new VDBGeneralException("Server error during upload: " + conn.getResponseCode(), new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }

    public Vdb getVdbFromVdb(Vdb v) throws VDBGeneralException {
        Vdb ret = new Vdb(v.getLang());
        try {
            HttpURLConnection conn = this.getConnection(this.getVdbBase() + "/" + v.getLang().toString() + "/get-vdb-from-vdb", "POST");
            this.addVdbPart(conn.getOutputStream(), v);
            if (conn.getResponseCode() != 200) {
                if (conn.getResponseCode() == 204) {
                    throw new VDBGeneralException("Package name is null", new Object[0]);
                }
                if (conn.getResponseCode() == 400) {
                    throw new VDBGeneralException("Server error during retrieval of vdb", new Object[0]);
                }
                if (conn.getResponseCode() == 404) {
                    return null;
                }
                throw new VDBGeneralException("Server error during signature vdb retrieval: " + conn.getResponseCode(), new Object[0]);
            }
            ret = this.getVdb(conn.getInputStream());
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
        return ret;
    }

    public Vdb uploadMethod(Method m) throws VDBGeneralException {
        if (m.isNcf()) {
            return this.uploadNonClassFunc(m);
        }
        try {
            HttpURLConnection conn = this.getConnection(this.getVdbBase() + "/" + m.getLang().toString() + "/add/" + m.getPackageName() + "/method", "PUT");
            Vdb v = new Vdb(m.getLang());
            v.addMethod(m);
            this.addVdbPart(conn.getOutputStream(), v);
            if (conn.getResponseCode() == 200) {
                return this.getVdb(conn.getInputStream());
            }
            if (conn.getResponseCode() == 204) {
                throw new VDBGeneralException("Invalid Vdb structure", new Object[0]);
            }
            if (conn.getResponseCode() == 400) {
                throw new VDBGeneralException("Rest server error during upload", new Object[0]);
            }
            throw new VDBGeneralException("Server error during upload: " + conn.getResponseCode(), new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
        catch (BadMarkupException e) {
            throw new VDBGeneralException(e);
        }
    }

    private Vdb uploadNonClassFunc(Method m) throws VDBGeneralException {
        try {
            HttpURLConnection conn = this.getConnection(this.getVdbBase() + "/" + m.getLang().toString() + "/add/non-class-funcs/non-class-func", "PUT");
            Vdb v = new Vdb(m.getLang());
            v.addMethod(m);
            this.addVdbPart(conn.getOutputStream(), v);
            if (conn.getResponseCode() == 200) {
                return this.getVdb(conn.getInputStream());
            }
            if (conn.getResponseCode() == 204) {
                throw new VDBGeneralException("Invalid Vdb structure", new Object[0]);
            }
            if (conn.getResponseCode() == 400) {
                throw new VDBGeneralException("Rest server error during upload", new Object[0]);
            }
            throw new VDBGeneralException("Server error during upload: " + conn.getResponseCode(), new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
        catch (BadMarkupException e) {
            throw new VDBGeneralException(e);
        }
    }

    public boolean deletePackage(String package_name) throws VDBGeneralException {
        try {
            HttpURLConnection conn = this.getConnection(this.getVdbBase() + "/" + this.m_lang.toString() + "/delete/" + package_name, "DELETE");
            if (conn.getResponseCode() == 200) {
                return true;
            }
            if (conn.getResponseCode() == 204) {
                return false;
            }
            if (conn.getResponseCode() == 400) {
                throw new VDBGeneralException("Rest server error during upload", new Object[0]);
            }
            if (conn.getResponseCode() == 404) {
                return false;
            }
            throw new VDBGeneralException("Server error during upload: " + conn.getResponseCode(), new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }

    public boolean deleteMethod(Method m) throws VDBGeneralException {
        if (m.isNcf()) {
            return this.deleteNonClassFunction(m);
        }
        try {
            HttpURLConnection conn = this.getConnection(this.getVdbBase() + "/" + this.m_lang.toString() + "/delete/" + m.getPackageName() + "/method", "DELETE");
            conn.addRequestProperty("Cookie", m.getSignature());
            if (conn.getResponseCode() == 200) {
                return true;
            }
            if (conn.getResponseCode() == 204) {
                throw new VDBGeneralException("Package {0} vdb not found.", m.getPackageName());
            }
            if (conn.getResponseCode() == 400) {
                throw new VDBGeneralException("Rest server error during upload", new Object[0]);
            }
            if (conn.getResponseCode() == 404) {
                return false;
            }
            throw new VDBGeneralException("Server error during upload: " + conn.getResponseCode(), new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }

    private boolean deleteNonClassFunction(Method m) throws VDBGeneralException {
        try {
            HttpURLConnection conn = this.getConnection(this.getVdbBase() + "/" + this.m_lang.toString() + "/delete/non-class-func", "DELETE");
            conn.addRequestProperty("Cookie", m.getSignature());
            if (conn.getResponseCode() == 200) {
                return true;
            }
            if (conn.getResponseCode() == 204) {
                throw new VDBGeneralException("Non class function vdb not found.", new Object[0]);
            }
            if (conn.getResponseCode() == 400) {
                throw new VDBGeneralException("Rest server error during upload", new Object[0]);
            }
            if (conn.getResponseCode() == 404) {
                return false;
            }
            throw new VDBGeneralException("Server error during upload: " + conn.getResponseCode(), new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }

    public Set<String> getPackages() throws VDBGeneralException {
        try {
            HttpURLConnection conn = this.getConnection(this.getListBase() + "/" + this.m_lang.toString() + "/packages", "GET");
            if (conn.getResponseCode() == 200) {
                return this.splitResponse(conn, "#");
            }
            throw new VDBGeneralException("Server error during packge list retrieval: " + conn.getResponseCode(), new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }

    public Set<String> getClassesForPackage(String package_name) throws VDBGeneralException {
        try {
            HttpURLConnection conn = this.getConnection(this.getListBase() + "/" + this.m_lang.toString() + "/packages/" + package_name, "GET");
            if (conn.getResponseCode() == 200) {
                return this.splitResponse(conn, "#");
            }
            throw new VDBGeneralException("Server error during signature vdb retrieval: " + conn.getResponseCode(), new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }

    public Set<String> getMethodsForClass(String package_name, String class_name) throws VDBGeneralException {
        try {
            HttpURLConnection conn = this.getConnection(this.getListBase() + "/" + this.m_lang.toString() + "/packages/" + package_name + "/" + class_name, "GET");
            if (conn.getResponseCode() == 200) {
                return this.splitResponse(conn, "#");
            }
            throw new VDBGeneralException("Server error during signature vdb retrieval: " + conn.getResponseCode(), new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }

    public Set<String> getNonClassMethods() throws VDBGeneralException {
        try {
            HttpURLConnection conn = this.getConnection(this.getListBase() + "/" + this.m_lang.toString() + "/non-class-functions", "GET");
            if (conn.getResponseCode() == 200) {
                return this.splitResponse(conn, "#");
            }
            throw new VDBGeneralException("Server error during signature vdb retrieval: " + conn.getResponseCode(), new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }

    public Vdb getPackageVdb(String package_name) throws VDBGeneralException {
        Vdb ret = null;
        try {
            HttpURLConnection conn = this.getConnection(this.getVdbBase() + "/" + this.m_lang.toString() + "/" + package_name, "GET");
            if (conn.getResponseCode() != 200) {
                if (conn.getResponseCode() == 204) {
                    throw new VDBGeneralException("Package name is null", new Object[0]);
                }
                if (conn.getResponseCode() == 400) {
                    throw new VDBGeneralException("Server error during retrieval of vdb", new Object[0]);
                }
                if (conn.getResponseCode() == 404) {
                    return null;
                }
                throw new VDBGeneralException("Server error during signature vdb retrieval: " + conn.getResponseCode(), new Object[0]);
            }
            ret = this.getVdb(conn.getInputStream());
            conn.disconnect();
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
        return ret;
    }

    public Vdb getNonClassFuncsVdb() throws VDBGeneralException {
        Vdb ret = null;
        try {
            HttpURLConnection conn = this.getConnection(this.getVdbBase() + "/" + this.m_lang.toString() + "/non-class-funcs", "GET");
            if (conn.getResponseCode() != 200) {
                if (conn.getResponseCode() == 400) {
                    throw new VDBGeneralException("Server error during retrieval of vdb", new Object[0]);
                }
                if (conn.getResponseCode() == 404) {
                    return null;
                }
                throw new VDBGeneralException("Server error during signature vdb retrieval: " + conn.getResponseCode(), new Object[0]);
            }
            ret = this.getVdb(conn.getInputStream());
            conn.disconnect();
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
        return ret;
    }

    public Vdb getMethod(String package_name, String method_name) throws VDBGeneralException {
        Vdb ret = null;
        try {
            HttpURLConnection conn = this.getConnection(this.getVdbBase() + "/" + this.m_lang.toString() + "/" + package_name + "/method", "GET");
            conn.addRequestProperty("Cookie", method_name);
            if (conn.getResponseCode() != 200) {
                if (conn.getResponseCode() == 404) {
                    return null;
                }
                if (conn.getResponseCode() == 204) {
                    return null;
                }
                throw new VDBGeneralException("Server error during method retrieval: " + conn.getResponseCode(), new Object[0]);
            }
            ret = this.getVdb(conn.getInputStream());
            conn.disconnect();
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
        return ret;
    }

    public Method findMethod(String method_name) throws VDBGeneralException {
        Vdb ret = null;
        try {
            HttpURLConnection conn = this.getConnection(this.getVdbBase() + "/" + this.m_lang.toString() + "/find-method", "GET");
            conn.addRequestProperty("Cookie", method_name);
            if (conn.getResponseCode() != 200) {
                if (conn.getResponseCode() == 404) {
                    return null;
                }
                if (conn.getResponseCode() == 204) {
                    return null;
                }
                return null;
            }
            ret = this.getVdb(conn.getInputStream());
            conn.disconnect();
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
        if (ret == null) {
            return null;
        }
        return ret.getMethod(method_name);
    }

    public Vdb getNonClassFunction(String method_name) throws VDBGeneralException {
        Vdb ret = null;
        try {
            HttpURLConnection conn = this.getConnection(this.getVdbBase() + "/" + this.m_lang.toString() + "/non-class-funcs/function", "GET");
            conn.addRequestProperty("Cookie", method_name);
            if (conn.getResponseCode() != 200) {
                if (conn.getResponseCode() == 404) {
                    return null;
                }
                if (conn.getResponseCode() == 204) {
                    return null;
                }
                throw new VDBGeneralException("Server error during signature vdb retrieval: " + conn.getResponseCode(), new Object[0]);
            }
            ret = this.getVdb(conn.getInputStream());
            conn.disconnect();
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
        return ret;
    }

    public Set<String> getClasses() throws VDBGeneralException {
        if (this.m_classes == null) {
            this.m_classes = new HashSet();
            for (String p : this.getPackages()) {
                this.m_classes.addAll(this.getClassesForPackage(p));
            }
        }
        return this.m_classes;
    }

    public Set<String> getMethods() throws VDBGeneralException {
        if (this.m_methods == null) {
            this.m_methods = new HashSet();
            for (String pack : this.getPackages()) {
                for (String c : this.getClassesForPackage(pack)) {
                    this.m_methods.addAll(this.getMethodsForClass(pack, c));
                }
            }
        }
        return this.m_methods;
    }
}

