/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.generatevdb;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.frameworks.analyzers.generic.LangIndependentWalaUtil;
import com.ibm.appscan.frameworks.handlers.generatevdb.util.Messages;
import com.ibm.appscan.frameworks.highlevelapi.F4FActions;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.F4FHandler;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.vdb.annotation.VdbAnnotation;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.JavaMethod;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.provider.data.file.save.VdbWriter;
import com.ibm.wala.andromeda.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.Pair;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;

public class GenerateVDBHandler
extends F4FHandler {
    final Logger logger = TaintLogger.i().getLogger();

    public void handleApp(F4FApp f4fApp, F4FActions f4fAction) {
        try {
            this.logger.info((Object)Messages.getMessage("generate.vdb.handler.running", new Object[0]));
            Vdb vdb = new Vdb(Language.LANGUAGE.JAVA);
            AnalysisCache cache = new AnalysisCache();
            Collection theClasses = f4fApp.getAllApplicationClasses();
            for (IClass currentClass : theClasses) {
                Collection classAnnotations = f4fApp.getClassAnnotations(currentClass);
                ArrayList<VdbAnnotation> vdbClassAnnotationList = new ArrayList<VdbAnnotation>();
                for (Annotation classAnnotation : classAnnotations) {
                    String theClassAnnotationTypeName = classAnnotation.getType().getName().toString();
                    String theClassAnnotationTypeNameVDBFormat = VDBJavaUtil.jvmToVDBType((String)theClassAnnotationTypeName);
                    VdbAnnotation vdbClassAnnotation = new VdbAnnotation(theClassAnnotationTypeNameVDBFormat);
                    Map classAnnotationNamedArgs = classAnnotation.getNamedArguments();
                    for (Map.Entry entry : classAnnotationNamedArgs.entrySet()) {
                        vdbClassAnnotation.addAnnotationMember((String)entry.getKey(), ((AnnotationsReader.ElementValue)entry.getValue()).toString());
                    }
                    Pair[] classAnnotationUnNamedArgs = classAnnotation.getUnnamedArguments();
                    if (classAnnotationUnNamedArgs != null) {
                        for (Pair pair : classAnnotationUnNamedArgs) {
                            vdbClassAnnotation.addAnnotationMember(pair.snd.toString());
                        }
                    }
                    vdbClassAnnotationList.add(vdbClassAnnotation);
                }
                ArrayList<String> classHierachyChain = new ArrayList<String>();
                IClass superClass = currentClass.getSuperclass();
                String superClassName = VDBJavaUtil.jvmToVDBType((String)superClass.getName().toString());
                while (!superClassName.equals("java.lang.Object")) {
                    int lastDotIndex = superClassName.lastIndexOf(46);
                    superClassName = superClassName.substring(lastDotIndex + 1);
                    classHierachyChain.add(superClassName);
                    superClass = superClass.getSuperclass();
                    superClassName = VDBJavaUtil.jvmToVDBType((String)superClass.getName().toString());
                }
                ArrayList<String> classInterfaces = new ArrayList<String>();
                Collection allImplementedInterfaces = currentClass.getAllImplementedInterfaces();
                String interfaceName = null;
                if (allImplementedInterfaces != null && allImplementedInterfaces.size() > 0) {
                    for (IClass iClass : allImplementedInterfaces) {
                        interfaceName = VDBJavaUtil.jvmToVDBType((String)iClass.getName().toString());
                        int lastDotIndex = interfaceName.lastIndexOf(46);
                        if (lastDotIndex != -1) {
                            interfaceName = interfaceName.substring(lastDotIndex + 1);
                        }
                        classInterfaces.add(interfaceName);
                    }
                }
                Collection methods = currentClass.getDeclaredMethods();
                for (IMethod declaredMethod : methods) {
                    String methodSignature = declaredMethod.getSignature();
                    String methodSignatureInVDBFormat = VDBJavaUtil.jvmToVDBSignature((String)methodSignature);
                    JavaMethod vdbMethod = null;
                    try {
                        vdbMethod = new JavaMethod(methodSignatureInVDBFormat);
                    }
                    catch (BadMarkupException e) {
                        this.logger.warn((Object)Messages.getMessage("generate.vdb.handler.failure.adding.method", methodSignatureInVDBFormat, e.toString() + Messages.getTraceFromException((Exception)((Object)e))));
                        continue;
                    }
                    vdbMethod.setClassAnnotations(vdbClassAnnotationList);
                    if (classHierachyChain.size() > 0) {
                        for (String s : classHierachyChain) {
                            vdbMethod.addClassHierachyChain(s);
                        }
                    }
                    if (classInterfaces.size() > 0) {
                        for (String s : classInterfaces) {
                            vdbMethod.addClassInterfaces(s);
                        }
                    }
                    IR ir = LangIndependentWalaUtil.getIR((IMethod)declaredMethod, (AnalysisCache)cache);
                    Collection methodAnnotations = f4fApp.getMethodAnnotations(declaredMethod);
                    for (Annotation methodAnnotation : methodAnnotations) {
                        String methodAnnotaitonTypeName = methodAnnotation.getType().getName().toString();
                        String methodAnnotationTypeNameInVDBFormat = VDBJavaUtil.jvmToVDBType((String)methodAnnotaitonTypeName);
                        VdbAnnotation vdbMethodAnnotation = new VdbAnnotation(methodAnnotationTypeNameInVDBFormat);
                        Map methodAnnotationNamedArgs = methodAnnotation.getNamedArguments();
                        for (Map.Entry entry : methodAnnotationNamedArgs.entrySet()) {
                            vdbMethodAnnotation.addAnnotationMember((String)entry.getKey(), ((AnnotationsReader.ElementValue)entry.getValue()).toString());
                        }
                        Pair[] methodAnnotationUnNamedArgs = methodAnnotation.getUnnamedArguments();
                        if (methodAnnotationUnNamedArgs != null) {
                            for (Pair pair : methodAnnotationUnNamedArgs) {
                                vdbMethodAnnotation.addAnnotationMember(pair.snd.toString());
                            }
                        }
                        vdbMethod.addMethodAnnotation(vdbMethodAnnotation);
                        Collection[] collectionArray = f4fApp.getMethodParametersAnnotations(declaredMethod);
                        int numParameters = declaredMethod.getNumberOfParameters();
                        boolean isStatic = declaredMethod.isStatic();
                        int index = 0;
                        if (!isStatic) {
                            // empty if block
                        }
                        for (int i = ++index; i < numParameters; ++i) {
                            String parameterTypeName = ir.getParameterType(i).getName().toString();
                            String parameterTypeNameInVDBFormat = VDBJavaUtil.jvmToVDBType((String)parameterTypeName);
                            Collection argAnnotationList = null;
                            argAnnotationList = isStatic ? collectionArray[i] : collectionArray[i - 1];
                            for (Annotation paramAnotation : argAnnotationList) {
                                String paramAnnotationTypeName = paramAnotation.getType().getName().toString();
                                String paramAnnotationTypeNameInVDBFormat = VDBJavaUtil.jvmToVDBType((String)paramAnnotationTypeName);
                                VdbAnnotation vdbParamAnnotation = new VdbAnnotation(paramAnnotationTypeNameInVDBFormat);
                                Map paramAnnotationNamedArgs = paramAnotation.getNamedArguments();
                                for (Map.Entry entry : paramAnnotationNamedArgs.entrySet()) {
                                    vdbParamAnnotation.addAnnotationMember((String)entry.getKey(), ((AnnotationsReader.ElementValue)entry.getValue()).toString());
                                }
                                Pair[] paramAnnotationUnNamedArgs = paramAnotation.getUnnamedArguments();
                                if (paramAnnotationUnNamedArgs != null) {
                                    for (Pair pair : paramAnnotationUnNamedArgs) {
                                        vdbParamAnnotation.addAnnotationMember(pair.snd.toString());
                                    }
                                }
                                vdbMethod.addArgAnnotation(parameterTypeNameInVDBFormat, vdbParamAnnotation);
                            }
                        }
                    }
                    try {
                        vdb.addMethod((Method)vdbMethod);
                    }
                    catch (BadMarkupException e) {
                        this.logger.warn((Object)Messages.getMessage("generate.vdb.handler.failure.adding.method", vdbMethod.getSignature(), e.toString() + Messages.getTraceFromException((Exception)((Object)e))));
                    }
                }
            }
            File vdbFile = new File(this.getFrameworksInput().getFileLocs().getOutputWAFLFileName()).getParentFile();
            try {
                File writeFile;
                File outputDir = new File(vdbFile.getCanonicalFile().getAbsolutePath() + File.separator + "vdb");
                if (!outputDir.exists()) {
                    outputDir.mkdirs();
                }
                if (!(writeFile = new File(outputDir + File.separator + "annotations.vdb")).exists()) {
                    writeFile.createNewFile();
                }
                FileOutputStream os = new FileOutputStream(writeFile);
                try {
                    VdbWriter VdbWriter2 = new VdbWriter((OutputStream)os);
                    VdbWriter2.writeVdb(vdb);
                }
                catch (VDBGeneralException e) {
                    this.logger.warn((Object)Messages.getMessage("generate.vdb.handler.failure.writing.vdb", e.toString() + Messages.getTraceFromException((Exception)((Object)e))));
                }
            }
            catch (IOException e) {
                this.logger.warn((Object)Messages.getMessage("generate.vdb.handler.failure.writing.vdb", e.toString() + Messages.getTraceFromException(e)));
            }
            this.logger.info((Object)Messages.getMessage("generate.vdb.handler.finished", new Object[0]));
        }
        catch (Exception e) {
            this.logger.warn((Object)Messages.getMessage("generate.vdb.handler.failure", e.toString() + Messages.getTraceFromException(e)));
        }
    }

    public boolean isApplicable() {
        if (!"true".equals(System.getProperty("ENABLE_ICA_FOR_F4F_VDB_GEN"))) {
            return false;
        }
        return this.getFrameworksInput().getType().equals("Java");
    }
}

