/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.spring;

import com.ibm.appscan.frameworks.analyzers.javaee.jsp.IJSPPrecompilerInfo;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.JspEntrypointResolver;
import com.ibm.appscan.frameworks.analyzers.spring.ISpringControllerInfo;
import com.ibm.appscan.frameworks.analyzers.spring.ModelAndViewUtil;
import com.ibm.appscan.frameworks.analyzers.spring.SpringAppConfigInfo;
import com.ibm.appscan.frameworks.analyzers.spring.SpringConfigFileInfo;
import com.ibm.appscan.frameworks.analyzers.spring.SpringEntrypointHandler;
import com.ibm.appscan.frameworks.analyzers.spring.SpringEntrypointInvokeInfo;
import com.ibm.appscan.frameworks.specinfo.FormalParameterExpr;
import com.ibm.appscan.frameworks.specinfo.ISyntheticMethod;
import com.ibm.appscan.frameworks.specinfo.InvokeExpr;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.ObjectRefExpr;
import com.ibm.appscan.frameworks.specinfo.SyntheticMethodImpl;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.strings.StringStuff;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ImplementsControllerInfo
implements ISpringControllerInfo {
    private static final Logger logger = TaintLogger.i().getLogger();
    public static final TypeReference SPRING_CONTROLLER = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)StringStuff.deployment2CanonicalTypeString((String)"org.springframework.web.servlet.mvc.Controller"));
    private static final Selector entrypointSelector = Selector.make((String)"handleRequest(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)Lorg/springframework/web/servlet/ModelAndView;");

    @Override
    public boolean isApplicable(IClass klass, IClassHierarchy cha) {
        logger.info((Object)Messages.getString("framework.handler.searching", "org.springframework.web.servlet.mvc.Controller", ""));
        IClass springControllerKlass = cha.lookupClass(SPRING_CONTROLLER);
        if (springControllerKlass == null) {
            logger.info((Object)Messages.getString("framework.missing", "org.springframework.web.servlet.mvc.Controller"));
            return false;
        }
        boolean result = cha.isAssignableFrom(springControllerKlass, klass);
        if (!result) {
            logger.info((Object)Messages.getString("framework.missing", "org.springframework.web.servlet.mvc.Controller"));
        }
        return result;
    }

    @Override
    public Collection<SpringEntrypointInvokeInfo> getSyntheticEntrypointMethods(IClass klass, SpringConfigFileInfo.SpringBeanInfo beanInfo, String idForSignature, IJSPPrecompilerInfo precompilerInfo, String webContentDir, SpringAppConfigInfo configInfo) {
        logger.info((Object)Messages.getString("framework.begin.syntheticmethod", SpringEntrypointHandler.createEntrypointVDBSignature(idForSignature)));
        ArrayList<InvokeExpr> statements = new ArrayList<InvokeExpr>(1);
        HashMap actualParameterPos2Value = HashMapFactory.make();
        actualParameterPos2Value.put(1, ObjectRefExpr.make((NonVoidSyntheticExpr)FormalParameterExpr.make((int)0), (String)""));
        actualParameterPos2Value.put(2, ObjectRefExpr.make((NonVoidSyntheticExpr)FormalParameterExpr.make((int)1), (String)""));
        IMethod entrypointMethod = klass.getMethod(entrypointSelector);
        logger.info((Object)Messages.getString("framework.generate.call", entrypointMethod.getSignature()));
        statements.add(VDBJavaUtil.invokeFromJVMSig(beanInfo.getFilePosInfo(), entrypointMethod.getSignature(), actualParameterPos2Value));
        statements.addAll(ModelAndViewUtil.getStatementsInvokingEntryOfView(entrypointMethod, new AnalysisCache(), configInfo, JspEntrypointResolver.make(precompilerInfo, webContentDir), beanInfo.getFilePosInfo(), webContentDir, beanInfo));
        logger.info((Object)Messages.getString("framework.generate.syntheticmethod", SpringEntrypointHandler.createEntrypointVDBSignature(idForSignature)));
        SyntheticMethodImpl synthMethod = new SyntheticMethodImpl(SpringEntrypointHandler.createEntrypointVDBSignature(idForSignature), Collections.emptySet(), statements);
        return Collections.singleton(SpringEntrypointInvokeInfo.make(entrypointMethod, (ISyntheticMethod)synthMethod, Collections.emptySet()));
    }
}

