/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.spring;

import com.ibm.appscan.frameworks.analyzers.spring.SpringConfigFileInfo;
import com.ibm.appscan.frameworks.analyzers.tiles.TilesAnalyzer;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SpringAppConfigInfo
implements Iterable<SpringConfigFileInfo.SpringBeanInfo> {
    private final Map<String, SpringConfigFileInfo.SpringBeanInfo> beanId2BeanInfo = HashMapFactory.make();
    private final Map<String, TilesAnalyzer> tilesInfoCache = HashMapFactory.make();

    public SpringAppConfigInfo(List<SpringConfigFileInfo> configFileInfo) {
        this.initBeanMap(configFileInfo);
    }

    private void initBeanMap(List<SpringConfigFileInfo> configFileInfo) {
        for (SpringConfigFileInfo fileInfo : configFileInfo) {
            for (SpringConfigFileInfo.SpringBeanInfo beanInfo : fileInfo.getAllBeanInfo()) {
                for (String name : beanInfo.getNames()) {
                    this.beanId2BeanInfo.put(name, beanInfo);
                }
                String id = beanInfo.getId();
                if (id == null) continue;
                this.beanId2BeanInfo.put(id, beanInfo);
            }
        }
    }

    public SpringConfigFileInfo.SpringBeanInfo getBeanInfo(String beanId) {
        return this.beanId2BeanInfo.get(beanId);
    }

    public Set<SpringConfigFileInfo.SpringBeanInfo> getAllBeanInfo() {
        return HashSetFactory.make(this.beanId2BeanInfo.values());
    }

    public TilesAnalyzer getTilesAnalyzer(String webContentDir, String configPaths) {
        TilesAnalyzer result = this.tilesInfoCache.get(configPaths);
        if (result == null) {
            result = TilesAnalyzer.createTilesAnalyzerFromConfigs(webContentDir, configPaths);
            this.tilesInfoCache.put(configPaths, result);
        }
        return result;
    }

    @Override
    public Iterator<SpringConfigFileInfo.SpringBeanInfo> iterator() {
        return this.beanId2BeanInfo.values().iterator();
    }
}

