/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.struts1;

import com.ibm.appscan.frameworks.analyzers.javaee.BeanUtil;
import com.ibm.appscan.frameworks.parsers.strutsParser.IFormBean;
import com.ibm.appscan.frameworks.parsers.strutsParser.IFormProperty;
import com.ibm.appscan.frameworks.parsers.strutsValidatorParser.IField;
import com.ibm.appscan.frameworks.parsers.strutsValidatorParser.IValidator;
import com.ibm.appscan.frameworks.specinfo.Property;
import com.ibm.appscan.frameworks.util.PropertyUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AnalyzedBean {
    public static final String DYNA_ACTION_FORM_CLASS = "org.apache.struts.action.DynaActionForm";
    private static final Set<String> DYNA_BEAN_CLASS_NAMES = HashSetFactory.make(Arrays.asList("org.apache.struts.action.DynaActionForm", "org.apache.struts.validator.DynaValidatorForm", "org.apache.struts.validator.DynaValidatorActionForm"));
    private static final Logger logger = TaintLogger.i().getLogger();
    private final IFormBean bean;
    private final Collection<Property> beanProperties;
    private final String beanClass;
    private final IClassHierarchy cha;
    private final Map<Property, List<IValidator>> propValidators = HashMapFactory.make();
    private final Set<IValidator> validatorsForBeanProperty = HashSetFactory.make();

    public AnalyzedBean(IFormBean bean, IClassHierarchy cha) {
        this.bean = bean;
        this.cha = cha;
        this.beanClass = this.getBeanClass(bean);
        this.beanProperties = this.beanClass != null ? (this.isDynaBean() ? this.getDynaBeanProperties(cha) : this.getPropertyNamesAndTypes(this.beanClass)) : HashSetFactory.make();
    }

    private String getBeanClass(IFormBean theBean) {
        String className;
        if (theBean.getClassName() != null && theBean.getType() != null) {
            logger.warn((Object)("Found a bean with both className and Type. Return type as the class name " + theBean.getName()));
        }
        if ((className = theBean.getClassName()) == null) {
            className = theBean.getType();
        }
        return className;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bean == null ? 0 : this.bean.hashCode());
        result = 31 * result + (this.beanClass == null ? 0 : this.beanClass.hashCode());
        result = 31 * result + (this.beanProperties == null ? 0 : this.beanProperties.hashCode());
        result = 31 * result + (this.propValidators == null ? 0 : this.propValidators.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnalyzedBean other = (AnalyzedBean)obj;
        if (this.bean == null ? other.bean != null : !this.bean.equals(other.bean)) {
            return false;
        }
        if (this.beanClass == null ? other.beanClass != null : !this.beanClass.equals(other.beanClass)) {
            return false;
        }
        if (this.beanProperties == null ? other.beanProperties != null : !this.beanProperties.equals(other.beanProperties)) {
            return false;
        }
        return !(this.propValidators == null ? other.propValidators != null : !this.propValidators.equals(other.propValidators));
    }

    private Collection<Property> getDynaBeanProperties(IClassHierarchy cha) {
        HashSet result = HashSetFactory.make();
        for (IFormProperty property : this.bean.getFormProperty()) {
            Property prop;
            TypeReference typeReference = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)("L" + property.getType().replace(".", "/")));
            if (cha.lookupClass(typeReference) == null || PropertyUtil.isFiltered(prop = PropertyUtil.propertyFromTypeRef(property.getName(), typeReference))) continue;
            result.add(prop);
        }
        return result;
    }

    public boolean isDynaBean() {
        return DYNA_BEAN_CLASS_NAMES.contains(this.beanClass);
    }

    public Collection<Property> getBeanProperties() {
        return this.beanProperties;
    }

    private Collection<Property> getPropertyNamesAndTypes(String theBeanClass) {
        return BeanUtil.getBeanProperties(theBeanClass, this.cha);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.beanClass != null) {
            sb.append("Bean Class= " + this.beanClass + "\n");
            sb.append("Bean Properties=");
            for (Property beanProp : this.beanProperties) {
                sb.append(beanProp.getName() + ":" + beanProp.getType());
                List<IValidator> validators = this.propValidators.get(beanProp);
                if (validators != null) {
                    sb.append(" validated by ");
                    for (IValidator validator : validators) {
                        sb.append(validator.getName() + "|");
                    }
                }
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public String getBeanClass() {
        return this.beanClass;
    }

    public void validateProperties(Collection<IField> validatedFields, Map<String, IValidator> validators) {
        for (IField f : validatedFields) {
            boolean foundProp = false;
            for (Property prop : this.beanProperties) {
                if (!prop.getName().equals(f.getProperty())) continue;
                this.addPropertyValidation(prop, this.getValidators(f.getDepends(), validators));
                foundProp = true;
                break;
            }
            if (foundProp) continue;
            logger.warn((Object)"could not find a match for a validated bean property");
        }
    }

    private List<IValidator> getValidators(String depends, Map<String, IValidator> validators) {
        String[] validatorNames;
        ArrayList<IValidator> result = new ArrayList<IValidator>();
        for (String validatorName : validatorNames = depends.split(",")) {
            if (!validators.containsKey(validatorName.trim())) {
                logger.warn((Object)("Couldn't find used validator name " + validatorName.trim() + " in list of validators"));
                continue;
            }
            result.add(validators.get(validatorName.trim()));
        }
        return result;
    }

    private void addPropertyValidation(Property prop, List<IValidator> validators) {
        List<IValidator> validatorsForProp = this.propValidators.get(prop);
        if (validatorsForProp == null) {
            validatorsForProp = new ArrayList<IValidator>();
        }
        validatorsForProp.addAll(validators);
        this.validatorsForBeanProperty.addAll(validators);
        this.propValidators.put(prop, validatorsForProp);
    }

    public Collection<IValidator> getValidatorsForProp(String propName) {
        for (Property prop : this.beanProperties) {
            if (!prop.getName().equals(propName)) continue;
            return this.propValidators.get(prop);
        }
        return null;
    }

    public Collection<IValidator> getValidators() {
        return this.validatorsForBeanProperty;
    }
}

