/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.json.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.JSONString;
import org.apache.commons.json.OrderedJSONObject;

public class Serializer {
    private Writer writer;

    public Serializer(Writer writer) {
        this.writer = writer;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public Serializer writeRawString(String string) throws IOException {
        this.writer.write(string);
        return this;
    }

    public Serializer writeNull() throws IOException {
        this.writeRawString("null");
        return this;
    }

    public Serializer writeNumber(Number number) throws IOException {
        if (null == number) {
            return this.writeNull();
        }
        if (number instanceof Float) {
            if (((Float)number).isNaN()) {
                return this.writeNull();
            }
            if (Float.NEGATIVE_INFINITY == number.floatValue()) {
                return this.writeNull();
            }
            if (Float.POSITIVE_INFINITY == number.floatValue()) {
                return this.writeNull();
            }
        }
        if (number instanceof Double) {
            if (((Double)number).isNaN()) {
                return this.writeNull();
            }
            if (Double.NEGATIVE_INFINITY == number.doubleValue()) {
                return this.writeNull();
            }
            if (Double.POSITIVE_INFINITY == number.doubleValue()) {
                return this.writeNull();
            }
        }
        this.writeRawString(number.toString());
        return this;
    }

    public Serializer writeBoolean(Boolean bl) throws IOException {
        if (null == bl) {
            return this.writeNull();
        }
        this.writeRawString(bl.toString());
        return this;
    }

    private String rightAlignedZero(String string, int n) {
        if (n == string.length()) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() < n) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }

    public Serializer writeString(String string) throws IOException {
        if (null == string) {
            return this.writeNull();
        }
        this.writer.write(34);
        char[] cArray = string.toCharArray();
        block11: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\"': {
                    this.writer.write("\\\"");
                    continue block11;
                }
                case '\\': {
                    this.writer.write("\\\\");
                    continue block11;
                }
                case '\u0000': {
                    this.writer.write("\\0");
                    continue block11;
                }
                case '\b': {
                    this.writer.write("\\b");
                    continue block11;
                }
                case '\t': {
                    this.writer.write("\\t");
                    continue block11;
                }
                case '\n': {
                    this.writer.write("\\n");
                    continue block11;
                }
                case '\f': {
                    this.writer.write("\\f");
                    continue block11;
                }
                case '\r': {
                    this.writer.write("\\r");
                    continue block11;
                }
                case '/': {
                    this.writer.write("\\/");
                    continue block11;
                }
                default: {
                    if (c >= ' ' && c <= '~') {
                        this.writer.write(c);
                        continue block11;
                    }
                    this.writer.write("\\u");
                    this.writer.write(this.rightAlignedZero(Integer.toHexString(c), 4));
                }
            }
        }
        this.writer.write(34);
        return this;
    }

    private Serializer write(Object object) throws IOException {
        Class<?> clazz;
        if (null == object) {
            return this.writeNull();
        }
        if (Number.class.isAssignableFrom(clazz = object.getClass())) {
            return this.writeNumber((Number)object);
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return this.writeBoolean((Boolean)object);
        }
        if (JSONObject.class.isAssignableFrom(clazz)) {
            return this.writeObject((JSONObject)object);
        }
        if (JSONArray.class.isAssignableFrom(clazz)) {
            return this.writeArray((JSONArray)object);
        }
        if (JSONString.class.isAssignableFrom(clazz)) {
            return this.writeRawString(((JSONString)object).toJSONString());
        }
        if (String.class.isAssignableFrom(clazz)) {
            return this.writeString((String)object);
        }
        throw new IOException("Attempting to serialize unserializable object: '" + object + "'");
    }

    public Serializer writeObject(JSONObject jSONObject) throws IOException {
        List list;
        if (null == jSONObject) {
            return this.writeNull();
        }
        this.writeRawString("{");
        this.indentPush();
        Iterator iterator = null;
        if (jSONObject instanceof OrderedJSONObject) {
            iterator = ((OrderedJSONObject)jSONObject).getOrder();
        } else {
            list = this.getPropertyNames(jSONObject);
            iterator = list.iterator();
        }
        while (iterator.hasNext()) {
            list = iterator.next();
            if (!(list instanceof String)) {
                throw new IOException("attempting to serialize object with an invalid property name: '" + list + "'");
            }
            Object v = jSONObject.get(list);
            if (!JSONObject.isValidObject(v)) {
                throw new IOException("attempting to serialize object with an invalid property value: '" + v + "'");
            }
            this.newLine();
            this.indent();
            this.writeString((String)((Object)list));
            this.writeRawString(":");
            this.space();
            this.write(v);
            if (!iterator.hasNext()) continue;
            this.writeRawString(",");
        }
        this.indentPop();
        this.newLine();
        this.indent();
        this.writeRawString("}");
        return this;
    }

    public Serializer writeArray(JSONArray jSONArray) throws IOException {
        if (null == jSONArray) {
            return this.writeNull();
        }
        this.writeRawString("[");
        this.indentPush();
        Iterator iterator = jSONArray.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!JSONObject.isValidObject(e)) {
                throw new IOException("attempting to serialize array with an invalid element: '" + jSONArray + "'");
            }
            this.newLine();
            this.indent();
            this.write(e);
            if (!iterator.hasNext()) continue;
            this.writeRawString(",");
        }
        this.indentPop();
        this.newLine();
        this.indent();
        this.writeRawString("]");
        return this;
    }

    public void space() throws IOException {
    }

    public void newLine() throws IOException {
    }

    public void indent() throws IOException {
    }

    public void indentPush() {
    }

    public void indentPop() {
    }

    public List getPropertyNames(Map map) {
        return new ArrayList(map.keySet());
    }
}

