/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.vs;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.IStrategyFactory;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Strategy;
import com.ibm.appscan.discovery.vs.Messages;
import com.ibm.appscan.discovery.vs.utils.VSUtil;
import com.ibm.appscan.internal.discovery.vs.AssemblyStrategy;
import java.io.File;
import java.util.Properties;

public class AssemblyStrategyFactory
implements IStrategyFactory {
    private static boolean alreadyLogged = false;

    public Strategy createStrategy(File fileOrDirectory, IStrategyFactoryRegistry registry) {
        if (!SystemUtil.isWindows() || SystemUtil.isCloudIRGen()) {
            return null;
        }
        String fileName = fileOrDirectory.getName().toLowerCase();
        AssemblyStrategy asmStrategy = null;
        if (fileName.endsWith(".dll") || fileName.endsWith(".exe")) {
            Properties props = VSUtil.getAssemblyProperties(fileOrDirectory);
            if (props == null || props.getProperty("assembly").equalsIgnoreCase("true")) {
                asmStrategy = new AssemblyStrategy(fileOrDirectory, props);
            } else if (!alreadyLogged) {
                alreadyLogged = true;
                CommonCore.getLogManager().log(new Message(2, Messages.getMessage("dotnet.assemblies.notfound", new Object[0])));
            }
        }
        return asmStrategy;
    }

    public boolean isBuildOutput() {
        return true;
    }

    public void loadUniqueTarget(IScan scan) {
    }
}

