/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.vs.targets;

import com.hcl.appscan.sdk.scanners.sast.targets.DotNetTarget;
import com.hcl.appscan.sdk.scanners.sast.targets.ISASTTarget;
import com.ibm.appscan.discovery.Strategy;
import com.ibm.appscan.discovery.vs.targets.IDotNetTargetAdapter;
import com.ibm.appscan.discovery.vs.utils.XamarinTargetUtil;
import com.ibm.appscan.internal.discovery.vs.AssemblyStrategy;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class AssemblyTargetAdapter
extends DotNetTarget
implements IDotNetTargetAdapter {
    private File m_assembly;
    private Properties m_props;

    public AssemblyTargetAdapter(File assembly, Properties props) {
        this.m_assembly = assembly;
        this.m_props = props;
    }

    public String getReferences() {
        return this.m_props.getProperty("references");
    }

    public String getFrameworkVersion() {
        return this.m_props.getProperty("framework_version");
    }

    public File getTargetFile() {
        return this.m_assembly;
    }

    @Override
    public Collection<ISASTTarget> toTargets() {
        ArrayList<ISASTTarget> targets = new ArrayList<ISASTTarget>();
        targets.add((ISASTTarget)this);
        targets.addAll(XamarinTargetUtil.getXamarinTargets(this.m_props));
        return targets;
    }

    @Override
    public Map<Strategy, Properties> toStrategies() {
        HashMap<Strategy, Properties> strategies = new HashMap<Strategy, Properties>();
        strategies.put(new AssemblyStrategy(this.m_assembly, this.m_props), this.m_props);
        strategies.putAll(XamarinTargetUtil.getXamarinStrategies(this.m_props));
        return strategies;
    }
}

