/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.vs;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanModelFactory;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Strategy;
import com.ibm.appscan.discovery.util.PackageNameUtil;
import com.ibm.appscan.discovery.vs.Messages;
import com.ibm.appscan.discovery.vs.utils.DotNetReferenceChecker;
import com.ibm.appscan.exclude.ExclusionProvider;
import com.ibm.appscan.exclude.exclusions.BaseExclusion;
import com.ibm.appscan.exclude.exclusions.ExclusionException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class AssemblyStrategy
extends Strategy {
    private File m_assembly;
    private Properties m_props = null;
    private List<String> m_namespaces = new ArrayList<String>();

    public AssemblyStrategy() {
    }

    AssemblyStrategy(File assembly) {
        this.init(assembly, null);
    }

    public AssemblyStrategy(File assembly, Properties props) {
        this(assembly);
        this.m_props = props;
    }

    public String getName() {
        return this.m_assembly.getName();
    }

    public String getType() {
        return Messages.getMessage("assembly", new Object[0]);
    }

    public String getPath() {
        return this.m_assembly.getAbsolutePath();
    }

    public String getStrategyClass() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getLanguageType() {
        return "DotNet";
    }

    public void init(File fileOrDirectory, IStrategyFactoryRegistry registry) {
        this.m_assembly = fileOrDirectory;
    }

    public void findScanTargets(IScanTargetProxy proxy, IProgress progress) {
        if (this.m_props != null) {
            for (String key : this.m_props.stringPropertyNames()) {
                proxy.getBuildInfo().setProperty(key, this.m_props.getProperty(key));
            }
        }
    }

    protected void validateScanTarget(IScanTargetMinProxy proxy, IProgress progress, Set<IScanFile> files) {
        proxy.getValidationIssues().addAll(new DotNetReferenceChecker(this.m_assembly, proxy).validate(progress));
    }

    protected void getNameSpaces(IScanTargetMinProxy proxy, Set<IScanFile> files) {
        if (this.m_props != null && this.m_props.containsKey("namespaces")) {
            String[] namespaces;
            for (String namespace : namespaces = this.m_props.getProperty("namespaces").split(";")) {
                namespace = PackageNameUtil.trimPackageName((String)namespace);
                this.m_namespaces.add(namespace);
            }
            proxy.getNameSpaces().addAll(this.m_namespaces);
        }
    }

    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        LinkedHashSet<IScanFile> scanFiles = new LinkedHashSet<IScanFile>();
        IScanFile scanFile = ScanModelFactory.newScanFile((File)this.m_assembly);
        scanFile.setExcluded(this.isExcluded(proxy));
        scanFiles.add(scanFile);
        return scanFiles;
    }

    private boolean isExcluded(IScanTargetMinProxy proxy) {
        proxy.inheritedSetBuildInfo("package_includes", null);
        proxy.inheritedSetBuildInfo("package_excludes", null);
        if (this.m_props != null && this.m_props.containsKey("namespaces")) {
            try {
                String[] namespaces;
                BaseExclusion exclusionProvider = ExclusionProvider.getExclusion((Language.LANGUAGE)Language.LANGUAGE.DOT_NET);
                if (proxy.getBuildInfo().containsKey("package_includes")) {
                    String[] packageIncludes = proxy.getBuildInfo().getProperty("package_includes").split(";");
                    exclusionProvider.addPackageIncludes(Arrays.asList(packageIncludes));
                }
                if (proxy.getBuildInfo().containsKey("package_excludes")) {
                    String[] packageExcludes = proxy.getBuildInfo().getProperty("package_excludes").split(";");
                    exclusionProvider.addPackageExcludes(Arrays.asList(packageExcludes));
                }
                for (String namespace : namespaces = this.m_props.getProperty("namespaces").split(";")) {
                    if (exclusionProvider.isPackageExcluded(namespace)) continue;
                    return false;
                }
                return true;
            }
            catch (ExclusionException e) {
                proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }
}

